/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.landmark;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.deprecated.HeadUtils;

public class LandmarkNoOwnerMenu
extends BasicGui {
    private final Landmark landmark;

    public LandmarkNoOwnerMenu(Player player, Landmark landmark) {
        super(player, Lang.HEADER_LANDMARK_UNCLAIMED.get(player), 3);
        this.landmark = landmark;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getLandmarkIcon(this.landmark));
        this.gui.setItem(2, 5, this.getClaimButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, HumanEntity::closeInventory));
        GuiItem panelGui = ItemBuilder.from(HeadUtils.createCustomItemStack(Material.GRAY_STAINED_GLASS_PANE, "", new String[0])).asGuiItem(event -> event.setCancelled(true));
        this.gui.getFiller().fillBottom(panelGui);
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getLandmarkIcon(Landmark landmark) {
        LangType lang = this.tanPlayer.getLang();
        return ItemBuilder.from(landmark.getIcon(lang)).asGuiItem(event -> event.setCancelled(true));
    }

    @NotNull
    private GuiItem getClaimButton() {
        TownData playerTown = TownDataStorage.getInstance().get(this.player);
        double cost = Constants.getClaimLandmarkCost();
        ArrayList<String> description = new ArrayList<String>();
        if (cost > 0.0) {
            description.add(Lang.GUI_LANDMARK_CLAIM_COST.get(this.player, String.valueOf(cost)));
        }
        boolean isRequirementsMet = true;
        if (!playerTown.canClaimMoreLandmarks()) {
            isRequirementsMet = false;
            description.add(Lang.GUI_LANDMARK_TOWN_FULL.get(this.tanPlayer));
        }
        if (Constants.isLandmarkClaimRequiresEncirclement() && !this.landmark.isEncircledBy(playerTown)) {
            isRequirementsMet = false;
            description.add(Lang.GUI_LANDMARK_NOT_ENCIRCLED.get(this.tanPlayer));
        }
        if (cost > playerTown.getBalance()) {
            isRequirementsMet = false;
            description.add(Lang.GUI_LANDMARK_NOT_ENOUGH_MONEY.get(this.tanPlayer, Double.toString(Constants.getClaimLandmarkCost())));
        }
        if (isRequirementsMet) {
            description.add(Lang.GUI_LANDMARK_LEFT_CLICK_TO_CLAIM.get(this.tanPlayer));
        }
        IconKey iconKey = isRequirementsMet ? IconKey.GUI_CONFIRM_CLAIM_LANDMARK_REQUIREMENTS_MET_ICON : IconKey.GUI_CONFIRM_CLAIM_LANDMARK_REQUIREMENTS_UNMET_ICON;
        boolean requirementMet = isRequirementsMet;
        return this.iconManager.get(iconKey).setName(Lang.GUI_TOWN_RELATION_ADD_TOWN.get(this.tanPlayer)).setDescription(description).setAction(event -> {
            if (!requirementMet) {
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                return;
            }
            double actualBalance = playerTown.getBalance();
            double newBalance = actualBalance - cost;
            PlayerGUI.openConfirmMenu(this.player, Lang.GUI_GENERIC_NEW_BALANCE_MENU.get(this.tanPlayer, Double.toString(actualBalance), Double.toString(newBalance)), confirm -> {
                playerTown.removeFromBalance(cost);
                this.landmark.setOwner(playerTown);
                playerTown.broadcastMessageWithSound(Lang.GUI_LANDMARK_CLAIMED.get(), SoundEnum.GOOD);
                PlayerGUI.dispatchLandmarkGui(this.player, this.landmark);
            }, cancel -> this.open());
        }).asGuiItem(this.player);
    }
}

