/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.RenterPropertyMenu;
import org.leralix.tan.gui.user.property.PlayerPropertyManager;
import org.leralix.tan.gui.user.property.PropertyMenus;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class BuyOrRentPropertyMenu
extends PropertyMenus {
    public BuyOrRentPropertyMenu(Player player, PropertyData propertyData) {
        super(player, Lang.HEADER_PLAYER_SPECIFIC_PROPERTY.get(player, propertyData.getName()), 3, propertyData);
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getPropertyIcon());
        this.gui.getFiller().fillTop(GuiUtil.getUnnamedItem(Material.BROWN_STAINED_GLASS_PANE));
        if (this.propertyData.isForSale()) {
            this.gui.setItem(2, 3, this.getConfirmBuyButton());
            this.gui.setItem(2, 7, this.getCancelBuyButton());
        }
        if (this.propertyData.isForRent()) {
            this.gui.setItem(2, 3, this.getConfirmRentButton());
            this.gui.setItem(2, 7, this.getCancelRentButton());
        }
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, HumanEntity::closeInventory));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getConfirmBuyButton() {
        double price = this.propertyData.getSalePrice();
        return this.iconManager.get(IconKey.CONFIRM_BUY_PROPERTY_ICON).setName(Lang.CONFIRM_SALE.get(this.tanPlayer)).setDescription(Lang.CONFIRM_SALE_DESC1.get(this.tanPlayer, Double.toString(price)), Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.tanPlayer)).setAction(action -> {
            this.propertyData.buyProperty(this.player);
            new PlayerPropertyManager(this.player, this.propertyData, p -> this.player.closeInventory());
        }).asGuiItem(this.player);
    }

    private GuiItem getCancelBuyButton() {
        return this.iconManager.get(IconKey.CANCEL_BUY_PROPERTY_ICON).setName(Lang.CANCEL_SALE.get(this.tanPlayer)).setDescription(Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.tanPlayer)).setAction(action -> this.player.closeInventory()).asGuiItem(this.player);
    }

    private GuiItem getConfirmRentButton() {
        double price = this.propertyData.getRentPrice();
        return this.iconManager.get(IconKey.CONFIRM_RENT_PROPERTY_ICON).setName(Lang.CONFIRM_RENT.get(this.tanPlayer)).setDescription(Lang.CONFIRM_RENT_DESC1.get(this.tanPlayer, Double.toString(price)), Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.tanPlayer)).setAction(event -> {
            this.propertyData.allocateRenter(this.player);
            new RenterPropertyMenu(this.player, this.propertyData);
        }).asGuiItem(this.player);
    }

    private GuiItem getCancelRentButton() {
        return this.iconManager.get(IconKey.CANCEL_RENT_PROPERTY_ICON).setName(Lang.CANCEL_RENT.get(this.tanPlayer)).setDescription(Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.tanPlayer)).setAction(action -> this.player.closeInventory()).asGuiItem(this.player);
    }
}

