/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.property.PropertyChunkSettingsMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.ChangePropertyDescription;
import org.leralix.tan.listeners.chat.events.ChangePropertyName;
import org.leralix.tan.listeners.chat.events.ChangePropertyRentPrice;
import org.leralix.tan.listeners.chat.events.ChangePropertySalePrice;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.NumberUtil;

public abstract class PropertyMenus
extends BasicGui {
    protected final PropertyData propertyData;

    protected PropertyMenus(Player player, String title, int rows, PropertyData propertyData) {
        super(player, title, rows);
        this.propertyData = propertyData;
    }

    protected GuiItem getPropertyIcon() {
        return this.iconManager.get(this.propertyData.getIcon()).setName(this.propertyData.getName()).setDescription(this.propertyData.getBasicDescription(this.tanPlayer.getLang())).asGuiItem(this.player);
    }

    protected GuiItem getRenameButton() {
        return this.iconManager.get(IconKey.PROPERTY_RENAME_ICON).setName(Lang.GUI_PROPERTY_CHANGE_NAME.get(this.langType, new String[0])).setDescription(Lang.GUI_PROPERTY_CHANGE_NAME_DESC1.get(this.langType, this.propertyData.getName()), Lang.GUI_GENERIC_CLICK_TO_RENAME.get(this.langType, new String[0])).setAction(action -> {
            this.player.sendMessage(Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
            PlayerChatListenerStorage.register(this.player, new ChangePropertyName(this.propertyData, p -> this.open()));
        }).asGuiItem(this.player);
    }

    protected GuiItem getDescriptionButton() {
        return this.iconManager.get(IconKey.PROPERTY_DESCRIPTION_ICON).setName(Lang.GUI_PROPERTY_CHANGE_DESCRIPTION.get(this.langType, new String[0])).setDescription(Lang.GUI_PROPERTY_CHANGE_DESCRIPTION_DESC1.get(this.langType, this.propertyData.getDescription()), Lang.GUI_GENERIC_CLICK_TO_RENAME.get(this.langType, new String[0])).setAction(action -> {
            this.player.sendMessage(Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
            PlayerChatListenerStorage.register(this.player, new ChangePropertyDescription(this.propertyData, p -> this.open()));
        }).asGuiItem(this.player);
    }

    protected GuiItem getBoundariesButton() {
        return this.iconManager.get(IconKey.PROPERTY_BOUNDS_ICON).setName(Lang.GUI_PROPERTY_DRAWN_BOX.get(this.langType, new String[0])).setDescription(Lang.GUI_GENERIC_CLICK_TO_SHOW.get(this.langType, new String[0])).setAction(action -> {
            this.player.closeInventory();
            this.propertyData.showBox(this.player);
        }).asGuiItem(this.player);
    }

    protected GuiItem forSaleButton() {
        IconKey iconKey = this.propertyData.isForSale() ? IconKey.SELL_PROPERTY_ICON_FOR_SALE : IconKey.SELL_PROPERTY_ICON_NOT_FOR_SALE;
        Lang name = this.propertyData.isForSale() ? Lang.GUI_PROPERTY_FOR_SALE : Lang.GUI_PROPERTY_NOT_FOR_SALE;
        double price = this.propertyData.getSalePrice();
        double taxPrice = NumberUtil.roundWithDigits(price * this.propertyData.getTown().getTaxOnBuyingProperty());
        double total = NumberUtil.roundWithDigits(price + taxPrice);
        return this.iconManager.get(iconKey).setName(name.get(this.langType, new String[0])).setDescription(Lang.GUI_BUYING_PRICE.get(this.langType, Double.toString(total), Double.toString(price), Double.toString(taxPrice)), Lang.GUI_TOWN_RATE.get(this.langType, String.format("%.2f", this.propertyData.getTown().getTaxOnBuyingProperty() * 100.0)), Lang.GUI_LEFT_CLICK_TO_SWITCH_SALE.get(this.langType, new String[0]), Lang.GUI_RIGHT_CLICK_TO_CHANGE_PRICE.get(this.langType, new String[0])).setAction(event -> {
            if (event.getClick() == ClickType.RIGHT) {
                this.player.sendMessage(Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
                PlayerChatListenerStorage.register(this.player, new ChangePropertySalePrice(this.propertyData, p -> this.open()));
                this.player.closeInventory();
            } else if (event.getClick() == ClickType.LEFT) {
                if (this.propertyData.isRented()) {
                    this.player.sendMessage(Lang.PROPERTY_ALREADY_RENTED.get(this.langType, new String[0]));
                    return;
                }
                this.propertyData.swapIsForSale();
                this.open();
            }
        }).asGuiItem(this.player);
    }

    protected GuiItem forRentButton() {
        IconKey iconKey = this.propertyData.isForRent() ? IconKey.RENT_PROPERTY_ICON_FOR_RENT : IconKey.RENT_PROPERTY_ICON_NOT_FOR_RENT;
        Lang name = this.propertyData.isForRent() ? Lang.GUI_PROPERTY_FOR_RENT : Lang.GUI_PROPERTY_NOT_FOR_RENT;
        double price = this.propertyData.getBaseRentPrice();
        double taxPrice = NumberUtil.roundWithDigits(price * this.propertyData.getTown().getTaxOnRentingProperty());
        double total = this.propertyData.getRentPrice();
        return this.iconManager.get(iconKey).setName(name.get(this.langType, new String[0])).setDescription(Lang.GUI_BUYING_PRICE.get(this.langType, Double.toString(total), Double.toString(price), Double.toString(taxPrice)), Lang.GUI_TOWN_RATE.get(this.langType, String.format("%.2f", this.propertyData.getTown().getTaxOnRentingProperty() * 100.0)), Lang.GUI_LEFT_CLICK_TO_SWITCH_SALE.get(this.langType, new String[0]), Lang.GUI_RIGHT_CLICK_TO_CHANGE_PRICE.get(this.langType, new String[0])).setAction(event -> {
            if (event.getClick() == ClickType.RIGHT) {
                this.player.sendMessage(Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
                PlayerChatListenerStorage.register(this.player, new ChangePropertyRentPrice(this.propertyData, p -> this.open()));
            } else if (event.getClick() == ClickType.LEFT) {
                if (this.propertyData.isRented()) {
                    this.player.sendMessage(Lang.PROPERTY_ALREADY_RENTED.get(this.langType, new String[0]));
                    return;
                }
                this.propertyData.swapIsRent();
                this.open();
            }
        }).asGuiItem(this.player);
    }

    protected GuiItem getDeleteButton() {
        return this.iconManager.get(IconKey.DELETE_PROPERTY_ICON).setName(Lang.GUI_PROPERTY_DELETE_PROPERTY.get(this.langType, new String[0])).setDescription(Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.langType, new String[0])).setAction(event -> PlayerGUI.openConfirmMenu(this.player, Lang.GUI_PROPERTY_DELETE_PROPERTY_CONFIRM.get(this.langType, this.propertyData.getName()), p -> {
            this.propertyData.delete();
            this.player.closeInventory();
        }, p -> this.open())).asGuiItem(this.player);
    }

    protected GuiItem getAuthorizedPlayersButton() {
        boolean isRentedAndPlayerIsNotRenter = this.propertyData.isRented() && !this.propertyData.getRenter().equals(this.tanPlayer);
        return this.iconManager.get(IconKey.AUTHORIZED_PLAYERS_ICON).setName(Lang.GUI_PROPERTY_PLAYER_LIST.get(this.langType, new String[0])).setDescription(isRentedAndPlayerIsNotRenter ? Lang.CANNOT_MANAGE_AUTHORIZED_PLAYER_IF_PROPERTY_IS_RENTED.get(this.langType, new String[0]) : Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.langType, new String[0])).setAction(event -> {
            if (isRentedAndPlayerIsNotRenter) {
                this.player.sendMessage(Lang.CANNOT_MANAGE_AUTHORIZED_PLAYER_IF_PROPERTY_IS_RENTED.get(this.langType, new String[0]));
                return;
            }
            new PropertyChunkSettingsMenu(this.player, this.propertyData, this);
        }).asGuiItem(this.player);
    }

    protected GuiItem getKickRenterButton() {
        return this.iconManager.get(new ItemStack(HeadUtils.getPlayerHead(this.propertyData.getOfflineRenter()))).setName(Lang.GUI_PROPERTY_RENTED_BY.get(this.langType, this.propertyData.getRenter().getNameStored())).setDescription(Lang.GUI_PROPERTY_RIGHT_CLICK_TO_EXPEL_RENTER.get(this.langType, new String[0])).setAction(event -> {
            event.setCancelled(true);
            Player renter = this.propertyData.getRenterPlayer();
            this.propertyData.expelRenter(false);
            this.player.sendMessage(Lang.PROPERTY_RENTER_EXPELLED_OWNER_SIDE.get(this.langType, new String[0]));
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
            if (renter != null) {
                renter.sendMessage(Lang.PROPERTY_RENTER_EXPELLED_RENTER_SIDE.get(this.langType, this.propertyData.getName()));
                SoundUtil.playSound((Player)renter, (SoundEnum)SoundEnum.MINOR_BAD);
            }
            this.open();
        }).asGuiItem(this.player);
    }
}

