/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.building.Building;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.interact.RightClickListener;
import org.leralix.tan.listeners.interact.events.CreateFortEvent;
import org.leralix.tan.utils.constants.Constants;

public class BuildingMenu
extends IteratorGUI {
    private final BasicGui previousMenu;
    private final TerritoryData territoryData;

    public BuildingMenu(Player player, TerritoryData territoryData, BasicGui previousMenu) {
        super(player, Lang.HEADER_BUILDING_MENU, 4);
        this.territoryData = territoryData;
        this.previousMenu = previousMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getBuildings(), p -> this.previousMenu.open());
        this.gui.setItem(4, 6, this.getCreateFortButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getCreateFortButton() {
        return this.iconManager.get(IconKey.FORT_BUILDING_ICON).setName(Lang.CREATE_FORT_ICON.get(this.langType, new String[0])).setDescription(Lang.CREATE_FORT_DESC1.get(this.langType, Double.toString(Constants.getFortCost())), Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.langType, new String[0])).setAction(action -> {
            if (Constants.getFortCost() > this.territoryData.getBalance()) {
                this.player.sendMessage(Lang.TERRITORY_NOT_ENOUGH_MONEY.get(this.langType, this.territoryData.getColoredName(), Double.toString(Constants.getFortCost() - this.territoryData.getBalance())));
                return;
            }
            this.player.sendMessage(Lang.RIGHT_CLICK_TO_PLACE_FORT.get(this.langType, new String[0]));
            RightClickListener.register(this.player, new CreateFortEvent(this.territoryData));
            this.player.closeInventory();
        }).asGuiItem(this.player);
    }

    private List<GuiItem> getBuildings() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        for (Building building : this.territoryData.getBuildings()) {
            res.add(building.getGuiItem(this.iconManager, this.player, this.territoryData, this));
        }
        return res;
    }
}

