/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.SelectFortForCapture;
import org.leralix.tan.gui.user.territory.SelectLandmarkForCapture;
import org.leralix.tan.gui.user.territory.SelectTerritoryForLIberation;
import org.leralix.tan.gui.user.territory.SelectWarGoals;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.SelectNbChunksForConquer;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.WarRole;
import org.leralix.tan.war.legacy.wargoals.ConquerWarGoal;
import org.leralix.tan.war.legacy.wargoals.SubjugateWarGoal;

public class ChooseWarGoal
extends BasicGui {
    private final TerritoryData territoryData;
    private final War war;
    private final WarRole warRole;

    public ChooseWarGoal(Player player, TerritoryData territoryData, War war, WarRole warRole) {
        super(player, Lang.HEADER_SELECT_WARGOAL, 3);
        this.territoryData = territoryData;
        this.war = war;
        this.warRole = warRole;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 2, this.getConquerButton());
        this.gui.setItem(2, 3, this.getcaptureLandmarkButton());
        this.gui.setItem(2, 4, this.getCaptureFortButton());
        this.gui.setItem(2, 7, this.getSubjugateButton());
        this.gui.setItem(2, 8, this.getLiberateButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new SelectWarGoals(this.player, this.territoryData, this.war, this.warRole)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getConquerButton() {
        boolean conquerAlreadyUsed = this.war.getGoals(this.warRole).stream().anyMatch(warGoal -> warGoal instanceof ConquerWarGoal);
        ArrayList<String> description = new ArrayList<String>();
        description.add(Lang.CONQUER_WAR_GOAL_DESC.get(this.tanPlayer));
        if (conquerAlreadyUsed) {
            description.add(Lang.GUI_ONLY_ONE_CONQUER_WAR_GOAL.get(this.tanPlayer));
        } else {
            description.add(Lang.GUI_GENERIC_CLICK_TO_SELECT.get(this.tanPlayer));
        }
        return this.iconManager.get(IconKey.WAR_GOAL_CONQUER_ICON).setName(Lang.CONQUER_WAR_GOAL.get(this.langType, new String[0])).setDescription(description).setAction(action -> {
            if (conquerAlreadyUsed) {
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                this.player.sendMessage(Lang.GUI_ONLY_ONE_CONQUER_WAR_GOAL.get(this.tanPlayer));
                return;
            }
            PlayerChatListenerStorage.register(this.player, new SelectNbChunksForConquer(this.war, this.warRole, new SelectWarGoals(this.player, this.territoryData, this.war, this.warRole)));
            this.player.closeInventory();
        }).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getcaptureLandmarkButton() {
        return this.iconManager.get(IconKey.WAR_GOAL_CAPTURE_LANDMARK_ICON).setName(Lang.CAPTURE_LANDMARK_WAR_GOAL.get(this.langType, new String[0])).setDescription(Lang.CAPTURE_LANDMARK_WAR_GOAL_DESC.get(this.tanPlayer), Lang.GUI_GENERIC_CLICK_TO_SELECT.get(this.tanPlayer)).setAction(action -> new SelectLandmarkForCapture(this.player, this.territoryData, this.war, this.warRole)).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getCaptureFortButton() {
        return this.iconManager.get(IconKey.WAR_GOAL_CAPTURE_FORT_ICON).setName(Lang.CAPTURE_FORT_WAR_GOAL.get(this.langType, new String[0])).setDescription(Lang.CAPTURE_FORT_WAR_GOAL_DESC.get(this.tanPlayer), Lang.GUI_GENERIC_CLICK_TO_SELECT.get(this.tanPlayer)).setAction(action -> new SelectFortForCapture(this.player, this.territoryData, this.war, this.warRole)).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getSubjugateButton() {
        boolean canBeSubjugated = this.warRole == WarRole.MAIN_ATTACKER ? this.war.getMainDefender().getHierarchyRank() < this.territoryData.getHierarchyRank() : this.war.getMainAttacker().getHierarchyRank() < this.territoryData.getHierarchyRank();
        ArrayList<String> description = new ArrayList<String>();
        description.add(Lang.SUBJUGATE_WAR_GOAL_DESC.get(this.langType, new String[0]));
        description.add(Lang.GUI_GENERIC_CLICK_TO_SELECT.get(this.langType, new String[0]));
        if (!canBeSubjugated) {
            description.add(Lang.GUI_WARGOAL_SUBJUGATE_CANNOT_BE_USED.get(this.langType, new String[0]));
        }
        return this.iconManager.get(IconKey.WAR_GOAL_SUBJUGATE_ICON).setName(Lang.SUBJUGATE_WAR_GOAL.get(this.langType, new String[0])).setDescription(description).setAction(action -> {
            if (!canBeSubjugated) {
                this.player.sendMessage(Lang.GUI_WARGOAL_SUBJUGATE_CANNOT_BE_USED.get(this.langType, new String[0]));
                return;
            }
            this.war.addGoal(this.warRole, new SubjugateWarGoal());
            new SelectWarGoals(this.player, this.territoryData, this.war, this.warRole);
        }).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getLiberateButton() {
        boolean doesEnemyHaveSubjects = this.warRole == WarRole.MAIN_ATTACKER ? !this.war.getMainDefender().getVassals().isEmpty() : !this.war.getMainAttacker().getVassals().isEmpty();
        ArrayList<String> description = new ArrayList<String>();
        description.add(Lang.LIBERATE_SUBJECT_WAR_GOAL_DESC.get(this.langType, new String[0]));
        description.add(Lang.GUI_GENERIC_CLICK_TO_SELECT.get(this.langType, new String[0]));
        if (!doesEnemyHaveSubjects) {
            description.add(Lang.GUI_WARGOAL_LIBERATE_CANNOT_BE_USED.get(this.langType, new String[0]));
        }
        return this.iconManager.get(IconKey.WAR_GOAL_LIBERATE_ICON).setName(Lang.LIBERATE_SUBJECT_WAR_GOAL.get(this.langType, new String[0])).setDescription(description).setAction(action -> {
            if (!doesEnemyHaveSubjects) {
                this.player.sendMessage(Lang.GUI_WARGOAL_LIBERATE_CANNOT_BE_USED.get(this.langType, new String[0]));
                return;
            }
            new SelectTerritoryForLIberation(this.player, this.territoryData, this.war, this.warRole);
        }).asGuiItem(this.player);
    }
}

