/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.territory.TerritoryChunkSettingsMenu;
import org.leralix.tan.lang.DynamicLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class ChunkSettingsMenu
extends BasicGui {
    private final TerritoryData territoryData;

    public ChunkSettingsMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_TOWN_MENU.get(player, territoryData.getName()), 3);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.getFiller().fillTop(GuiUtil.getUnnamedItem(Material.LIME_STAINED_GLASS_PANE));
        this.gui.setItem(2, 3, this.getChunkIcon());
        this.gui.setItem(2, 5, this.getChunkGeneralSettings());
        this.gui.setItem(2, 7, this.getChunkMobSpawnSettings());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, this.territoryData::openMainMenu));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getChunkIcon() {
        return this.iconManager.get(IconKey.LANDS_PERMISSION_ICON).setName(Lang.GUI_TOWN_CHUNK_PLAYER.get(this.tanPlayer)).setDescription(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new TerritoryChunkSettingsMenu(this.player, this.territoryData)).asGuiItem(this.player);
    }

    private GuiItem getChunkGeneralSettings() {
        return this.iconManager.get(IconKey.GENERAL_SETTINGS_ICON).setName(Lang.CHUNK_GENERAL_SETTINGS.get(this.tanPlayer)).setDescription(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> PlayerGUI.openChunkGeneralSettings(this.player, this.territoryData)).asGuiItem(this.player);
    }

    private GuiItem getChunkMobSpawnSettings() {
        return this.iconManager.get(IconKey.MOBS_SPAWN_SETTINGS_ICON).setName(Lang.GUI_TOWN_CHUNK_MOB.get(this.tanPlayer)).setDescription(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> {
            TerritoryData patt0$temp = this.territoryData;
            if (patt0$temp instanceof TownData) {
                TownData townData = (TownData)patt0$temp;
                if (townData.getLevel().getBenefitsLevel("UNLOCK_MOB_BAN") >= 1) {
                    PlayerGUI.openTownChunkMobSettings(this.player, 0);
                } else {
                    this.player.sendMessage(Lang.TOWN_NOT_ENOUGH_LEVEL.get(this.tanPlayer, DynamicLang.get(this.tanPlayer.getLang(), "UNLOCK_MOB_BAN")));
                    SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                }
            }
        }).asGuiItem(this.player);
    }
}

