/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.BrowseScope;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.MainMenu;
import org.leralix.tan.gui.user.territory.BrowseTerritoryMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.CreateRegion;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class NoRegionMenu
extends BasicGui {
    public NoRegionMenu(Player player) {
        super(player, Lang.HEADER_NO_REGION, 3);
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 3, this.getCreateRegionButton());
        this.gui.setItem(2, 7, this.getBrowseRegionsButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new MainMenu(this.player).open()));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getCreateRegionButton() {
        int regionCost = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("regionCost");
        return this.iconManager.get(IconKey.CREATE_REGION_ICON).setName(Lang.GUI_REGION_CREATE.get(this.tanPlayer)).setDescription(Lang.GUI_REGION_CREATE_DESC1.get(this.tanPlayer, Integer.toString(regionCost)), Lang.GUI_REGION_CREATE_DESC2.get(this.tanPlayer)).setAction(action -> {
            if (!this.player.hasPermission("tan.base.region.create")) {
                this.player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                return;
            }
            if (!this.tanPlayer.hasTown()) {
                this.player.sendMessage(Lang.PLAYER_NO_TOWN.get(this.tanPlayer));
                return;
            }
            TownData townData = TownDataStorage.getInstance().get(this.player);
            double townMoney = townData.getBalance();
            if (townMoney < (double)regionCost) {
                this.player.sendMessage(Lang.TERRITORY_NOT_ENOUGH_MONEY.get(this.tanPlayer, townData.getColoredName(), Double.toString((double)regionCost - townMoney)));
            } else {
                this.player.sendMessage(Lang.WRITE_IN_CHAT_NEW_REGION_NAME.get(this.tanPlayer));
                this.player.closeInventory();
                int cost = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("regionCost");
                PlayerChatListenerStorage.register(this.player, new CreateRegion(cost));
            }
        }).asGuiItem(this.player);
    }

    private GuiItem getBrowseRegionsButton() {
        return this.iconManager.get(IconKey.BROWSE_REGION_ICON).setName(Lang.GUI_REGION_BROWSE.get(this.tanPlayer)).setDescription(Lang.GUI_REGION_BROWSE_DESC1.get(this.tanPlayer, Integer.toString(RegionDataStorage.getInstance().getAll().size())), Lang.GUI_REGION_BROWSE_DESC2.get(this.tanPlayer)).setAction(action -> new BrowseTerritoryMenu(this.player, null, BrowseScope.REGIONS, p -> this.open())).asGuiItem(this.player);
    }
}

