/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.TerritoryMemberMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.deprecated.HeadUtils;

public class PlayerApplicationMenu
extends IteratorGUI {
    TownData townData;

    public PlayerApplicationMenu(Player player, TownData townData) {
        super(player, Lang.HEADER_TOWN_APPLICATIONS, 3);
        this.townData = townData;
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getApplicationList(), this.page, this.player, p -> new TerritoryMemberMenu(this.player, this.townData).open(), p -> this.nextPage(), p -> this.previousPage(), Material.LIME_STAINED_GLASS_PANE);
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getApplicationList() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String playerUUID : this.townData.getPlayerJoinRequestSet()) {
            OfflinePlayer playerIterate = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUUID));
            ITanPlayer playerIterateData = PlayerDataStorage.getInstance().get(playerUUID);
            ItemStack playerHead = HeadUtils.getPlayerHead(playerIterate, Lang.GUI_PLAYER_ASK_JOIN_PROFILE_DESC2.get(this.tanPlayer), Lang.GUI_PLAYER_ASK_JOIN_PROFILE_DESC3.get(this.tanPlayer));
            GuiItem playerButton = ItemBuilder.from(playerHead).asGuiItem(event -> {
                event.setCancelled(true);
                if (event.isLeftClick()) {
                    if (!this.townData.doesPlayerHavePermission(this.tanPlayer, RolePermission.INVITE_PLAYER)) {
                        this.player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                        SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                        return;
                    }
                    if (this.townData.isFull()) {
                        this.player.sendMessage(Lang.INVITATION_TOWN_FULL.get(this.tanPlayer));
                        SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                        return;
                    }
                    this.townData.addPlayer(playerIterateData);
                } else if (event.isRightClick()) {
                    if (!this.townData.doesPlayerHavePermission(this.tanPlayer, RolePermission.KICK_PLAYER)) {
                        this.player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                        return;
                    }
                    this.townData.removePlayerJoinRequest(playerIterateData.getID());
                }
                this.open();
            });
            guiItems.add(playerButton);
        }
        return guiItems;
    }
}

