/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.ChooseWarGoal;
import org.leralix.tan.gui.user.war.WarMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.WarRole;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class SelectWarGoals
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final War war;
    private final WarRole warRole;

    public SelectWarGoals(Player player, TerritoryData territoryData, War war, WarRole warRole) {
        super(player, Lang.HEADER_SELECT_WARGOAL.get(player), 3);
        this.territoryData = territoryData;
        this.war = war;
        this.warRole = warRole;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getWarGoals(), p -> new WarMenu(this.player, this.territoryData, this.war));
        this.gui.setItem(3, 5, this.getNewWarGoalButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getNewWarGoalButton() {
        return this.iconManager.get(IconKey.NEW_WAR_GOAL_ICON).setName(Lang.GUI_ADD_WAR_GOAL.get(this.langType, new String[0])).setDescription(Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.langType, new String[0])).setAction(action -> new ChooseWarGoal(this.player, this.territoryData, this.war, this.warRole)).asGuiItem(this.player);
    }

    private List<GuiItem> getWarGoals() {
        ArrayList<GuiItem> items = new ArrayList<GuiItem>();
        for (WarGoal goal : this.war.getGoals(this.warRole)) {
            items.add(goal.getIcon(this.langType).setAction(event -> {
                if (event.isRightClick()) {
                    this.war.removeGoal(this.warRole, goal);
                    this.open();
                }
            }).asGuiItem(this.player));
        }
        return items;
    }
}

