/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.relation;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.relation.OpenRelationMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public class AddRelationMenu
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final TownRelation wantedRelation;

    public AddRelationMenu(Player player, TerritoryData territory, TownRelation wantedRelation) {
        super(player, Lang.HEADER_SELECT_ADD_TERRITORY_RELATION.get(player, wantedRelation.getName(PlayerDataStorage.getInstance().get(player).getLang())), 6);
        this.territoryData = territory;
        this.wantedRelation = wantedRelation;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getTerritories(), p -> new OpenRelationMenu(this.player, this.territoryData, this.wantedRelation), Material.GREEN_STAINED_GLASS_PANE);
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getTerritories() {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(this.player);
        List<String> relationListID = this.territoryData.getRelations().getTerritoriesIDWithRelation(this.wantedRelation);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        ArrayList<String> territories = new ArrayList<String>();
        territories.addAll(TownDataStorage.getInstance().getAll().keySet());
        territories.addAll(RegionDataStorage.getInstance().getAll().keySet());
        territories.removeAll(relationListID);
        territories.remove(this.territoryData.getID());
        for (String otherTownUUID : territories) {
            TerritoryData otherTerritory = TerritoryUtil.getTerritory(otherTownUUID);
            ItemStack icon = otherTerritory.getIconWithInformationAndRelation(this.territoryData, tanPlayer.getLang());
            TownRelation actualRelation = this.territoryData.getRelationWith(otherTerritory);
            if (!actualRelation.canBeChanged()) continue;
            GuiItem iconGui = ItemBuilder.from(icon).asGuiItem(event -> {
                event.setCancelled(true);
                if (otherTerritory.haveNoLeader()) {
                    this.player.sendMessage(Lang.TOWN_DIPLOMATIC_INVITATION_NO_LEADER.get(tanPlayer));
                    return;
                }
                if (this.wantedRelation.isSuperiorTo(actualRelation)) {
                    otherTerritory.receiveDiplomaticProposal(this.territoryData, this.wantedRelation);
                    this.player.sendMessage(Lang.DIPLOMATIC_INVITATION_SENT_SUCCESS.get(tanPlayer, otherTerritory.getName()));
                } else {
                    this.territoryData.setRelation(otherTerritory, this.wantedRelation);
                }
                new OpenRelationMenu(this.player, this.territoryData, this.wantedRelation);
            });
            guiItems.add(iconGui);
        }
        return guiItems;
    }
}

