/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.relation;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.territory.relation.OpenDiplomacyProposalsMenu;
import org.leralix.tan.gui.user.territory.relation.OpenRelationMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class OpenDiplomacyMenu
extends BasicGui {
    private final TerritoryData territoryData;

    public OpenDiplomacyMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_RELATIONS.get(player, territoryData.getName()), 3);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(9, this.getWarButton());
        this.gui.setItem(11, this.getEmbargoButton());
        this.gui.setItem(13, this.getNonAggressionPactButton());
        this.gui.setItem(15, this.getAllianceButton());
        this.gui.setItem(17, this.getProposalButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> PlayerGUI.dispatchPlayerTown(this.player)));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getWarButton() {
        return this.iconManager.get(IconKey.GUI_WAR_ICON).setName(Lang.GUI_TOWN_RELATION_HOSTILE.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_RELATION_HOSTILE_DESC1.get(this.langType, this.territoryData.getName()), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.langType, new String[0])).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.WAR)).asGuiItem(this.player);
    }

    private GuiItem getEmbargoButton() {
        return this.iconManager.get(IconKey.GUI_EMBARGO_ICON).setName(Lang.GUI_TOWN_RELATION_EMBARGO.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_RELATION_EMBARGO_DESC1.get(this.langType, this.territoryData.getName()), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.langType, new String[0])).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.EMBARGO)).asGuiItem(this.player);
    }

    private GuiItem getNonAggressionPactButton() {
        return this.iconManager.get(IconKey.GUI_NON_AGGRESSION_PACT_ICON).setName(Lang.GUI_TOWN_RELATION_HOSTILE.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_RELATION_HOSTILE_DESC1.get(this.langType, this.territoryData.getName()), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.langType, new String[0])).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.NON_AGGRESSION)).asGuiItem(this.player);
    }

    private GuiItem getAllianceButton() {
        return this.iconManager.get(IconKey.GUI_ALLIANCE_ICON).setName(Lang.GUI_TOWN_RELATION_ALLIANCE.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_RELATION_ALLIANCE_DESC1.get(this.langType, this.territoryData.getName()), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.langType, new String[0])).setAction(p -> new OpenRelationMenu(this.player, this.territoryData, TownRelation.ALLIANCE)).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getProposalButton() {
        return this.iconManager.get(IconKey.GUI_PROPOSALS_ICON).setName(Lang.GUI_TOWN_RELATION_DIPLOMACY_PROPOSAL.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_RELATION_DIPLOMACY_PROPOSAL_DESC1.get(this.tanPlayer), Lang.GUI_TOWN_RELATION_DIPLOMACY_PROPOSAL_DESC2.get(this.tanPlayer, Integer.toString(this.territoryData.getAllDiplomacyProposal().size()))).setAction(action -> {
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_TOWN_RELATION)) {
                this.player.sendMessage(Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                return;
            }
            new OpenDiplomacyProposalsMenu(this.player, this.territoryData);
        }).asGuiItem(this.player);
    }
}

