/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.relation;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.relation.OpenRelationMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public class RemoveRelationMenu
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final TownRelation relation;

    public RemoveRelationMenu(Player player, TerritoryData territoryData, TownRelation relation) {
        super(player, Lang.HEADER_SELECT_REMOVE_TERRITORY_RELATION.get(player, relation.getName(PlayerDataStorage.getInstance().get(player).getLang())), 6);
        this.territoryData = territoryData;
        this.relation = relation;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getTerritories(), p -> new OpenRelationMenu(this.player, this.territoryData, this.relation), Material.RED_STAINED_GLASS_PANE);
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getTerritories() {
        List<String> relationListID = this.territoryData.getRelations().getTerritoriesIDWithRelation(this.relation);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String otherTownUUID : relationListID) {
            TerritoryData otherTerritory = TerritoryUtil.getTerritory(otherTownUUID);
            ItemStack townIcon = otherTerritory.getIconWithInformationAndRelation(this.territoryData, this.tanPlayer.getLang());
            GuiItem townGui = ItemBuilder.from(townIcon).asGuiItem(event -> {
                event.setCancelled(true);
                if (this.relation.isSuperiorTo(TownRelation.NEUTRAL)) {
                    this.territoryData.setRelation(otherTerritory, TownRelation.NEUTRAL);
                } else {
                    otherTerritory.receiveDiplomaticProposal(this.territoryData, TownRelation.NEUTRAL);
                    this.player.sendMessage(Lang.DIPLOMATIC_INVITATION_SENT_SUCCESS.get(this.tanPlayer, otherTerritory.getName()));
                    SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
                }
                new OpenRelationMenu(this.player, this.territoryData, this.relation);
            });
            guiItems.add(townGui);
        }
        return guiItems;
    }
}

