/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.war;

import dev.triumphteam.gui.guis.GuiItem;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.AttackDeclaredInternalEvent;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.territory.AttackMenu;
import org.leralix.tan.gui.user.war.WarMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlannedAttackStorage;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.DateUtil;
import org.leralix.tan.war.War;
import org.leralix.tan.war.WarTimeSlot;
import org.leralix.tan.war.legacy.CreateAttackData;
import org.leralix.tan.war.legacy.WarRole;

public class CreateAttackMenu
extends BasicGui {
    private final CreateAttackData attackData;
    private final TerritoryData territoryData;
    private final War war;
    private final WarRole warRole;

    public CreateAttackMenu(Player player, TerritoryData territoryData, War war, WarRole warRole) {
        super(player, Lang.HEADER_CREATE_WAR_MANAGER.get(player, war.getMainDefender().getName()), 3);
        this.territoryData = territoryData;
        this.war = war;
        this.warRole = warRole;
        this.attackData = new CreateAttackData(war, warRole);
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 2, this.getRemoveTimeButton());
        this.gui.setItem(2, 3, this.getTimeIcon());
        this.gui.setItem(2, 4, this.getAddTimeButton());
        this.gui.setItem(2, 8, this.getConfirmButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, e -> new WarMenu(this.player, this.territoryData, this.war)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getConfirmButton() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        boolean isValid = this.isValid(errorMessages);
        IconKey iconKey = isValid ? IconKey.CONFIRM_WAR_START_ICON : IconKey.CONFIRM_WAR_START_IMPOSSIBLE_ICON;
        return this.iconManager.get(iconKey).setName(Lang.GUI_CONFIRM_ATTACK.get(this.tanPlayer)).setDescription(errorMessages.isEmpty() ? Collections.singleton(Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.tanPlayer)) : errorMessages).setAction(event -> {
            event.setCancelled(true);
            if (!isValid) {
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.REMOVE);
                return;
            }
            EventManager.getInstance().callEvent(new AttackDeclaredInternalEvent(this.war.getTerritory(this.warRole.opposite()), this.war.getTerritory(this.warRole)));
            PlannedAttackStorage.getInstance().newAttack(this.attackData);
            new AttackMenu(this.player, this.war.getTerritory(this.warRole));
        }).asGuiItem(this.player);
    }

    private boolean isValid(List<String> errorMessages) {
        boolean isValid = true;
        Instant warStart = Instant.now().plusSeconds(this.attackData.getSelectedTime() / 20L);
        if (!WarTimeSlot.getInstance().canWarBeDeclared(warStart)) {
            errorMessages.add(Lang.GUI_WARGOAL_OUTSIDE_AUTHORIZED_SLOTS.get(this.tanPlayer));
            isValid = false;
        }
        return isValid;
    }

    @NotNull
    private GuiItem getAddTimeButton() {
        return this.iconManager.get(IconKey.ADD_WAR_START_TIME_ICON).setName(Lang.GUI_ATTACK_ADD_TIME.get(this.tanPlayer)).setDescription(Lang.GUI_LEFT_CLICK_FOR_1_MINUTE.get(this.tanPlayer), Lang.GUI_SHIFT_CLICK_FOR_1_HOUR.get(this.tanPlayer)).setAction(event -> {
            event.setCancelled(true);
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.REMOVE);
            if (event.isShiftClick()) {
                this.attackData.addDeltaDateTime(72000L);
            } else if (event.isLeftClick()) {
                this.attackData.addDeltaDateTime(1200L);
            }
            this.open();
        }).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getTimeIcon() {
        Instant startTime = Instant.now().plusSeconds(this.attackData.getSelectedTime() / 20L);
        ArrayList<String> availableTimeSlots = new ArrayList<String>();
        availableTimeSlots.add(TimeZoneManager.getInstance().formatDateForPlayer(this.tanPlayer, startTime));
        availableTimeSlots.add(Lang.AUTHORIZED_ATTACK_TIME_SLOT_TITLE.get(this.langType, new String[0]));
        availableTimeSlots.addAll(WarTimeSlot.getInstance().getPrintedTimeSlots(this.langType));
        return IconManager.getInstance().get(IconKey.WAR_START_TIME_ICON).setName(Lang.GUI_ATTACK_SET_TO_START_IN.get(this.tanPlayer, DateUtil.getDateStringFromTicks(this.attackData.getSelectedTime()))).setDescription(availableTimeSlots).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getRemoveTimeButton() {
        return this.iconManager.get(IconKey.REMOVE_WAR_START_TIME_ICON).setName(Lang.GUI_ATTACK_REMOVE_TIME.get(this.tanPlayer)).setDescription(Lang.GUI_LEFT_CLICK_FOR_1_MINUTE.get(this.tanPlayer), Lang.GUI_SHIFT_CLICK_FOR_1_HOUR.get(this.tanPlayer)).setAction(event -> {
            event.setCancelled(true);
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.REMOVE);
            if (event.isShiftClick()) {
                this.attackData.addDeltaDateTime(-72000L);
            } else if (event.isLeftClick()) {
                this.attackData.addDeltaDateTime(-1200L);
            }
            this.open();
        }).asGuiItem(this.player);
    }
}

