/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners;

import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.constants.Constants;

public class CommandBlocker
implements Listener {
    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        String inputCommand;
        Player player = event.getPlayer();
        if (CommandBlocker.isPlayerInAnAttack(player, inputCommand = event.getMessage()) || CommandBlocker.relationForbidCommandWithPlayer(player, inputCommand, Constants.getAllRelationBlacklistedCommands())) {
            event.setCancelled(true);
        }
    }

    static boolean relationForbidCommandWithPlayer(Player sender, String inputCommand, Set<String> allBlacklistedCommands) {
        String normalizedInput = inputCommand.trim();
        String[] inputParts = normalizedInput.split(" ");
        for (String blackListedCommand : allBlacklistedCommands) {
            ITanPlayer receiverData;
            ITanPlayer senderData;
            TownRelation worstRelationWithPlayer;
            Player receiver;
            boolean nextCommand = false;
            String selectedPlayer = null;
            String[] blackListedParts = blackListedCommand.split(" ");
            if (blackListedParts.length > inputParts.length) continue;
            for (int i = 0; i < blackListedParts.length; ++i) {
                if (blackListedParts[i].equals("%PLAYER%")) {
                    selectedPlayer = inputParts[i];
                    continue;
                }
                if (blackListedParts[i].equals(inputParts[i])) continue;
                nextCommand = true;
                break;
            }
            if (nextCommand || selectedPlayer == null || (receiver = Bukkit.getPlayer(selectedPlayer)) == null || !Constants.getRelationConstants(worstRelationWithPlayer = (senderData = PlayerDataStorage.getInstance().get(sender)).getRelationWithPlayer(receiverData = PlayerDataStorage.getInstance().get(receiver))).getBlockedCommands().contains(blackListedCommand)) continue;
            LangType lang = senderData.getLang();
            sender.sendMessage(Lang.CANNOT_CAST_COMMAND_ON_PLAYER_WITH_SPECIFIC_RELATION.get(lang, receiver.getName(), worstRelationWithPlayer.getColoredName(lang)));
            return true;
        }
        return false;
    }

    private static boolean isPlayerInAnAttack(Player player, String inputCommand) {
        if (PlayerDataStorage.getInstance().get(player).getAttackInvolvedIn().isEmpty()) {
            for (String blackListedCommands : Constants.getBlacklistedCommandsDuringAttacks()) {
                if (!blackListedCommands.startsWith(inputCommand)) continue;
                return true;
            }
        }
        return false;
    }
}

