/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners.chat.events;

import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.ChatListenerEvent;

public class ChangeLandmarkName
extends ChatListenerEvent {
    private final Landmark landmark;
    private final Consumer<Player> guiCallback;

    public ChangeLandmarkName(Landmark landmark, Consumer<Player> guiCallback) {
        this.landmark = landmark;
        this.guiCallback = guiCallback;
    }

    @Override
    public boolean execute(Player player, String message) {
        int nameMaxSize = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("landmarkNameMaxSize", 25);
        if (message.length() >= nameMaxSize) {
            player.sendMessage(Lang.MESSAGE_TOO_LONG.get(player, Integer.toString(nameMaxSize)));
            return false;
        }
        this.landmark.setName(message);
        player.sendMessage(Lang.CHANGE_MESSAGE_SUCCESS.get(player));
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_LEVEL_UP);
        this.openGui(this.guiCallback, player);
        return true;
    }
}

