/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners.chat.events;

import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.ChatListenerEvent;

public class CreateRank
extends ChatListenerEvent {
    private final TerritoryData territoryData;
    private final Consumer<Player> guiCallback;

    public CreateRank(TerritoryData townData, Consumer<Player> guiCallback) {
        this.territoryData = townData;
        this.guiCallback = guiCallback;
    }

    @Override
    public boolean execute(Player player, String message) {
        int maxNameSize = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("RankNameSize");
        if (message.length() > maxNameSize) {
            player.sendMessage(Lang.MESSAGE_TOO_LONG.get(player, Integer.toString(maxNameSize)));
            return false;
        }
        if (this.territoryData.isRankNameUsed(message)) {
            player.sendMessage(Lang.NAME_ALREADY_USED.get(player));
            return false;
        }
        this.territoryData.registerNewRank(message);
        this.openGui(this.guiCallback, player);
        return true;
    }
}

