/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners.chat.events;

import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.ChatListenerEvent;

public class RetrieveMoney
extends ChatListenerEvent {
    TerritoryData territoryData;

    public RetrieveMoney(TerritoryData territoryData) {
        this.territoryData = territoryData;
    }

    @Override
    public boolean execute(Player player, String message) {
        Double amount = RetrieveMoney.parseStringToDouble(message);
        if (amount == null) {
            player.sendMessage(Lang.SYNTAX_ERROR_AMOUNT.get(player));
            return false;
        }
        if (amount > this.territoryData.getBalance()) {
            player.sendMessage(Lang.TERRITORY_NOT_ENOUGH_MONEY.get(player, this.territoryData.getColoredName(), Double.toString(amount - this.territoryData.getBalance())));
            return false;
        }
        this.territoryData.removeFromBalance(amount);
        EconomyUtil.addFromBalance(player, (double)amount);
        player.sendMessage(Lang.TOWN_RETRIEVE_MONEY_SUCCESS.get(player, Double.toString(amount)));
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_LEVEL_UP);
        return true;
    }
}

