/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners.chat.events.treasury;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.user.territory.TreasuryMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.ChatListenerEvent;

public abstract class SetSpecificRate
extends ChatListenerEvent {
    protected final TerritoryData territoryData;

    protected SetSpecificRate(TerritoryData territoryData) {
        this.territoryData = territoryData;
    }

    @Override
    public boolean execute(Player player, String message) {
        Double amount = SetSpecificRate.parseStringToDouble(message);
        if (amount == null) {
            player.sendMessage(Lang.SYNTAX_ERROR_AMOUNT.get(player));
            return false;
        }
        amount = Math.min(100.0, Math.max(0.0, amount));
        player.sendMessage(Lang.TOWN_SET_RATE_SUCCESS.get(player, Double.toString(amount)));
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_GOOD);
        this.setRate(amount / 100.0);
        Bukkit.getScheduler().runTask((Plugin)TownsAndNations.getPlugin(), () -> new TreasuryMenu(player, this.territoryData));
        return false;
    }

    abstract void setRate(double var1);
}

