/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.enums.permissions.ChunkPermissionType;

public class WildernessRules {
    private final Map<String, Map<ChunkPermissionType, Boolean>> rules = new HashMap<String, Map<ChunkPermissionType, Boolean>>();
    private static WildernessRules instance;

    private WildernessRules() {
        this.init();
    }

    public static WildernessRules getInstance() {
        if (instance == null) {
            instance = new WildernessRules();
        }
        return instance;
    }

    public void init() {
        ConfigurationSection config = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getConfigurationSection("wildernessRules");
        if (config == null) {
            EnumMap<ChunkPermissionType, Boolean> defaultRules = new EnumMap<ChunkPermissionType, Boolean>(ChunkPermissionType.class);
            for (ChunkPermissionType permissionType : ChunkPermissionType.values()) {
                defaultRules.put(permissionType, true);
            }
            this.rules.put("default", defaultRules);
            return;
        }
        this.registerWorld(config, "default");
        for (World world : Bukkit.getWorlds()) {
            String worldName = world.getName();
            if (!config.contains(worldName)) continue;
            this.registerWorld(config, worldName);
        }
    }

    private void registerWorld(ConfigurationSection config, String worldName) {
        ConfigurationSection worldConfig = config.getConfigurationSection(worldName);
        EnumMap<ChunkPermissionType, Boolean> worldRules = new EnumMap<ChunkPermissionType, Boolean>(ChunkPermissionType.class);
        for (ChunkPermissionType permissionType : ChunkPermissionType.values()) {
            worldRules.put(permissionType, worldConfig.getBoolean(permissionType.toString(), true));
        }
        this.rules.put(worldName, worldRules);
    }

    public Boolean canPlayerDoInWilderness(World world, ChunkPermissionType permissionType) {
        if (!this.rules.containsKey(world.getName())) {
            return this.rules.get("default").get((Object)permissionType);
        }
        return this.rules.get(world.getName()).get((Object)permissionType);
    }
}

