/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.LandmarkClaimedChunk;
import org.leralix.tan.dataclass.chunk.RegionClaimedChunk;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.chunk.TownClaimedChunk;
import org.leralix.tan.dataclass.chunk.WildernessChunk;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.stored.JsonStorage;

public class NewClaimedChunkStorage
extends JsonStorage<ClaimedChunk2> {
    private static NewClaimedChunkStorage instance;

    private NewClaimedChunkStorage() {
        super("TAN - Claimed Chunks.json", new TypeToken<HashMap<String, ClaimedChunk2>>(){}.getType(), new GsonBuilder().setPrettyPrinting().create());
    }

    public static synchronized NewClaimedChunkStorage getInstance() {
        if (instance == null) {
            instance = new NewClaimedChunkStorage();
        }
        return instance;
    }

    private static String getChunkKey(Chunk chunk) {
        return NewClaimedChunkStorage.getChunkKey(chunk.getX(), chunk.getZ(), chunk.getWorld().getUID().toString());
    }

    private static String getChunkKey(ClaimedChunk2 chunk) {
        return NewClaimedChunkStorage.getChunkKey(chunk.getX(), chunk.getZ(), chunk.getWorldUUID());
    }

    private static String getChunkKey(int x, int z, String chunkWorldUID) {
        return x + "," + z + "," + chunkWorldUID;
    }

    public Map<String, ClaimedChunk2> getClaimedChunksMap() {
        return this.dataMap;
    }

    public boolean isChunkClaimed(Chunk chunk) {
        return this.dataMap.containsKey(NewClaimedChunkStorage.getChunkKey(chunk));
    }

    public Collection<TerritoryChunk> getAllChunkFrom(TerritoryData territoryData) {
        return this.getAllChunkFrom(territoryData.getID());
    }

    public Collection<TerritoryChunk> getAllChunkFrom(String territoryDataID) {
        ArrayList<TerritoryChunk> chunks = new ArrayList<TerritoryChunk>();
        for (ClaimedChunk2 chunk : this.dataMap.values()) {
            TerritoryChunk territoryChunk;
            if (!(chunk instanceof TerritoryChunk) || !(territoryChunk = (TerritoryChunk)chunk).getOwnerID().equals(territoryDataID)) continue;
            chunks.add(territoryChunk);
        }
        return Collections.unmodifiableCollection(chunks);
    }

    public TownClaimedChunk claimTownChunk(Chunk chunk, String ownerID) {
        TownClaimedChunk townClaimedChunk = new TownClaimedChunk(chunk, ownerID);
        this.dataMap.put(NewClaimedChunkStorage.getChunkKey(chunk), townClaimedChunk);
        this.save();
        return townClaimedChunk;
    }

    public void claimRegionChunk(Chunk chunk, String ownerID) {
        this.dataMap.put(NewClaimedChunkStorage.getChunkKey(chunk), new RegionClaimedChunk(chunk, ownerID));
        this.save();
    }

    public void claimLandmarkChunk(Chunk chunk, String ownerID) {
        this.dataMap.put(NewClaimedChunkStorage.getChunkKey(chunk), new LandmarkClaimedChunk(chunk, ownerID));
        this.save();
    }

    public boolean isAllAdjacentChunksClaimedBySameTerritory(Chunk chunk, String territoryID) {
        List<String> adjacentChunkKeys = Arrays.asList(NewClaimedChunkStorage.getChunkKey(chunk.getX() + 1, chunk.getZ(), chunk.getWorld().getUID().toString()), NewClaimedChunkStorage.getChunkKey(chunk.getX() - 1, chunk.getZ(), chunk.getWorld().getUID().toString()), NewClaimedChunkStorage.getChunkKey(chunk.getX(), chunk.getZ() + 1, chunk.getWorld().getUID().toString()), NewClaimedChunkStorage.getChunkKey(chunk.getX(), chunk.getZ() - 1, chunk.getWorld().getUID().toString()));
        for (String adjacentChunkKey : adjacentChunkKeys) {
            TerritoryChunk territoryChunk;
            ClaimedChunk2 adjacentClaimedChunk = (ClaimedChunk2)this.dataMap.get(adjacentChunkKey);
            if (adjacentClaimedChunk == null) {
                return false;
            }
            if (!(adjacentClaimedChunk instanceof TerritoryChunk) || (territoryChunk = (TerritoryChunk)adjacentClaimedChunk).getOccupierID().equals(territoryID)) continue;
            return false;
        }
        return true;
    }

    public boolean isOneAdjacentChunkClaimedBySameTerritory(Chunk chunk, String townID) {
        List<String> adjacentChunkKeys = Arrays.asList(NewClaimedChunkStorage.getChunkKey(chunk.getX() + 1, chunk.getZ(), chunk.getWorld().getUID().toString()), NewClaimedChunkStorage.getChunkKey(chunk.getX() - 1, chunk.getZ(), chunk.getWorld().getUID().toString()), NewClaimedChunkStorage.getChunkKey(chunk.getX(), chunk.getZ() + 1, chunk.getWorld().getUID().toString()), NewClaimedChunkStorage.getChunkKey(chunk.getX(), chunk.getZ() - 1, chunk.getWorld().getUID().toString()));
        for (String adjacentChunkKey : adjacentChunkKeys) {
            ClaimedChunk2 adjacentClaimedChunk = (ClaimedChunk2)this.dataMap.get(adjacentChunkKey);
            if (adjacentClaimedChunk == null || !adjacentClaimedChunk.getOwnerID().equals(townID)) continue;
            return true;
        }
        return false;
    }

    public void unclaimChunkAndUpdate(ClaimedChunk2 claimedChunk) {
        this.unclaimChunk(claimedChunk);
        claimedChunk.notifyUpdate();
    }

    public void unclaimChunk(ClaimedChunk2 claimedChunk) {
        this.dataMap.remove(NewClaimedChunkStorage.getChunkKey(claimedChunk));
        this.save();
    }

    public void unclaimChunk(Chunk chunk) {
        this.unclaimChunk(this.get(chunk));
    }

    @NotNull
    public List<ClaimedChunk2> getFourAjacentChunks(ClaimedChunk2 chunk) {
        return Arrays.asList(this.get(chunk.getX(), chunk.getZ() - 1, chunk.getWorld().getUID().toString()), this.get(chunk.getX() + 1, chunk.getZ(), chunk.getWorld().getUID().toString()), this.get(chunk.getX(), chunk.getZ() + 1, chunk.getWorld().getUID().toString()), this.get(chunk.getX() - 1, chunk.getZ(), chunk.getWorld().getUID().toString()));
    }

    @NotNull
    public List<ClaimedChunk2> getEightAjacentChunks(ClaimedChunk2 chunk) {
        return Arrays.asList(this.get(chunk.getX(), chunk.getZ() - 1, chunk.getWorld().getUID().toString()), this.get(chunk.getX() + 1, chunk.getZ() - 1, chunk.getWorld().getUID().toString()), this.get(chunk.getX() + 1, chunk.getZ(), chunk.getWorld().getUID().toString()), this.get(chunk.getX() + 1, chunk.getZ() + 1, chunk.getWorld().getUID().toString()), this.get(chunk.getX(), chunk.getZ() + 1, chunk.getWorld().getUID().toString()), this.get(chunk.getX() - 1, chunk.getZ() + 1, chunk.getWorld().getUID().toString()), this.get(chunk.getX() - 1, chunk.getZ(), chunk.getWorld().getUID().toString()), this.get(chunk.getX() - 1, chunk.getZ() - 1, chunk.getWorld().getUID().toString()));
    }

    public void unclaimAllChunksFromTerritory(TerritoryData territoryData) {
        this.unclaimAllChunkFromID(territoryData.getID());
    }

    public void unclaimAllChunkFromID(String id) {
        Iterator iterator = this.dataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ClaimedChunk2 chunk = (ClaimedChunk2)entry.getValue();
            if (!chunk.getOwnerID().equals(id)) continue;
            iterator.remove();
        }
    }

    public ClaimedChunk2 get(int x, int z, String worldID) {
        ClaimedChunk2 claimedChunk = (ClaimedChunk2)this.dataMap.get(NewClaimedChunkStorage.getChunkKey(x, z, worldID));
        if (claimedChunk == null) {
            return new WildernessChunk(x, z, worldID);
        }
        return claimedChunk;
    }

    @NotNull
    public ClaimedChunk2 get(Chunk chunk) {
        ClaimedChunk2 claimedChunk = (ClaimedChunk2)this.dataMap.get(NewClaimedChunkStorage.getChunkKey(chunk));
        if (claimedChunk == null) {
            return new WildernessChunk(chunk);
        }
        return claimedChunk;
    }

    @Override
    protected void load() {
        this.dataMap = new LinkedHashMap();
        Gson gson = new Gson();
        File file = NewClaimedChunkStorage.getFile("TAN - Claimed Chunks.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<Map<String, JsonObject>>(){}.getType();
                Map jsonData = (Map)gson.fromJson((Reader)reader, type);
                for (Map.Entry entry : jsonData.entrySet()) {
                    String occupierID;
                    JsonObject chunkData = (JsonObject)entry.getValue();
                    JsonObject vector2D = chunkData.getAsJsonObject("vector2D");
                    int x = vector2D.get("x").getAsInt();
                    int z = vector2D.get("z").getAsInt();
                    String worldUUID = vector2D.get("worldID").getAsString();
                    String ownerID = chunkData.get("ownerID").getAsString();
                    if (ownerID.startsWith("T")) {
                        TownClaimedChunk townChunk = new TownClaimedChunk(x, z, worldUUID, ownerID);
                        occupierID = chunkData.has("occupierID") ? chunkData.get("occupierID").getAsString() : ownerID;
                        townChunk.setOccupierID(occupierID);
                        this.dataMap.put((String)entry.getKey(), townChunk);
                        continue;
                    }
                    if (ownerID.startsWith("R")) {
                        RegionClaimedChunk regionChunk = new RegionClaimedChunk(x, z, worldUUID, ownerID);
                        occupierID = chunkData.has("occupierID") ? chunkData.get("occupierID").getAsString() : ownerID;
                        regionChunk.setOccupierID(occupierID);
                        this.dataMap.put((String)entry.getKey(), regionChunk);
                        continue;
                    }
                    if (!ownerID.startsWith("L")) continue;
                    LandmarkClaimedChunk landmarkClaimedChunk = new LandmarkClaimedChunk(x, z, worldUUID, ownerID);
                    this.dataMap.put((String)entry.getKey(), landmarkClaimedChunk);
                }
            }
            catch (IOException e) {
                TownsAndNations.getPlugin().getLogger().severe("Error while loading claimed chunks stats");
            }
        }
    }

    @Override
    public void reset() {
        this.dataMap = new HashMap();
    }
}

