/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.stored.JsonStorage;
import org.leralix.tan.storage.typeadapter.WargoalTypeAdapter;
import org.leralix.tan.war.PlannedAttack;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.CreateAttackData;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class PlannedAttackStorage
extends JsonStorage<PlannedAttack> {
    private static PlannedAttackStorage instance;

    protected PlannedAttackStorage() {
        super("TAN - Planned_wars.json", new TypeToken<HashMap<String, PlannedAttack>>(){}.getType(), new GsonBuilder().registerTypeAdapter((Type)((Object)WarGoal.class), new WargoalTypeAdapter()).setPrettyPrinting().create());
    }

    public static PlannedAttackStorage getInstance() {
        if (instance == null) {
            instance = new PlannedAttackStorage();
        }
        return instance;
    }

    public PlannedAttack newAttack(CreateAttackData createAttackData) {
        String newID = this.getNewID();
        long deltaDateTime = createAttackData.getSelectedTime();
        PlannedAttack plannedAttack = new PlannedAttack(newID, createAttackData, deltaDateTime);
        this.put(newID, plannedAttack);
        return plannedAttack;
    }

    private void setupAllAttacks() {
        for (PlannedAttack plannedAttack : this.getAll().values()) {
            plannedAttack.setUpStartOfAttack();
        }
    }

    private String getNewID() {
        int ID = 0;
        while (this.dataMap.containsKey("W" + ID)) {
            ++ID;
        }
        return "W" + ID;
    }

    public void territoryDeleted(TerritoryData territoryData) {
        Iterator iterator = this.getAll().values().iterator();
        while (iterator.hasNext()) {
            PlannedAttack plannedAttack = (PlannedAttack)iterator.next();
            War war = plannedAttack.getWar();
            if (war == null || !war.isMainAttacker(territoryData) && !war.isMainDefender(territoryData)) continue;
            plannedAttack.end();
            iterator.remove();
        }
    }

    public void delete(PlannedAttack plannedAttack) {
        this.delete(plannedAttack.getID());
    }

    @Override
    public void reset() {
    }
}

