/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.NoPlayerData;
import org.leralix.tan.dataclass.PlayerData;
import org.leralix.tan.storage.stored.JsonStorage;

public class PlayerDataStorage
extends JsonStorage<ITanPlayer> {
    private static final String ERROR_MESSAGE = "Error while creating player storage";
    private static PlayerDataStorage instance;
    private static ITanPlayer NO_PLAYER;

    private PlayerDataStorage() {
        super("TAN - Players.json", new TypeToken<HashMap<String, PlayerData>>(){}.getType(), new GsonBuilder().setPrettyPrinting().create());
    }

    public static synchronized PlayerDataStorage getInstance() {
        if (instance == null) {
            instance = new PlayerDataStorage();
            NO_PLAYER = new NoPlayerData();
        }
        return instance;
    }

    public ITanPlayer register(Player p) {
        PlayerData tanPlayer = new PlayerData(p);
        return this.register(tanPlayer);
    }

    ITanPlayer register(ITanPlayer p) {
        this.put(p.getID(), p);
        return p;
    }

    public ITanPlayer get(OfflinePlayer player) {
        return this.get(player.getUniqueId().toString());
    }

    public ITanPlayer get(Player player) {
        return this.get(player.getUniqueId().toString());
    }

    public ITanPlayer get(UUID playerID) {
        return this.get(playerID.toString());
    }

    @Override
    public ITanPlayer get(String id) {
        if (id == null) {
            return NO_PLAYER;
        }
        ITanPlayer res = (ITanPlayer)this.dataMap.get(id);
        if (res != null) {
            return res;
        }
        Player newPlayer = Bukkit.getPlayer((UUID)UUID.fromString(id));
        if (newPlayer != null) {
            return this.register(newPlayer);
        }
        throw new RuntimeException("Error : Player ID [" + id + "] has not been found");
    }

    @Override
    public void reset() {
        instance = null;
    }
}

