/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.dataclass.territory.cosmetic.ICustomIcon;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.JsonStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.storage.typeadapter.EnumMapDeserializer;
import org.leralix.tan.storage.typeadapter.IconAdapter;
import org.leralix.tan.utils.file.FileUtil;

public class RegionDataStorage
extends JsonStorage<RegionData> {
    private int nextID;
    private static RegionDataStorage instance;

    public static RegionDataStorage getInstance() {
        if (instance == null) {
            instance = new RegionDataStorage();
        }
        return instance;
    }

    private RegionDataStorage() {
        super("TAN - Regions.json", new TypeToken<LinkedHashMap<String, RegionData>>(){}.getType(), new GsonBuilder().registerTypeAdapter(new TypeToken<Map<TownRelation, List<String>>>(){}.getType(), new EnumMapDeserializer(TownRelation.class, new TypeToken<List<String>>(){}.getType())).registerTypeAdapter((Type)((Object)ICustomIcon.class), new IconAdapter()).setPrettyPrinting().create());
    }

    public RegionData createNewRegion(String name, TownData capital) {
        ITanPlayer newLeader = capital.getLeaderData();
        String regionID = this.generateNextID();
        RegionData newRegion = new RegionData(regionID, name, newLeader);
        this.put(regionID, newRegion);
        capital.setOverlord(newRegion);
        FileUtil.addLineToHistory(Lang.REGION_CREATED_NEWSLETTER.get(newLeader.getNameStored(), name));
        return newRegion;
    }

    @NotNull
    private String generateNextID() {
        String regionID = "R" + this.nextID;
        ++this.nextID;
        return regionID;
    }

    public RegionData get(Player player) {
        return this.get(PlayerDataStorage.getInstance().get(player));
    }

    public RegionData get(ITanPlayer tanPlayer) {
        TownData town = TownDataStorage.getInstance().get(tanPlayer);
        if (town == null) {
            return null;
        }
        return town.getRegion();
    }

    public void deleteRegion(RegionData region) {
        this.delete(region.getID());
    }

    public boolean isNameUsed(String name) {
        for (RegionData region : this.getAll().values()) {
            if (!region.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load() {
        super.load();
        int id = 0;
        for (String keys : this.getAll().keySet()) {
            int newID = Integer.parseInt(keys.substring(1));
            if (newID <= id) continue;
            id = newID;
        }
        this.nextID = id + 1;
    }

    @Override
    public void reset() {
        instance = null;
    }
}

