/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.dataclass.territory.cosmetic.ICustomIcon;
import org.leralix.tan.dataclass.territory.permission.RelationPermission;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.storage.stored.JsonStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.typeadapter.EnumMapDeserializer;
import org.leralix.tan.storage.typeadapter.EnumMapKeyValueDeserializer;
import org.leralix.tan.storage.typeadapter.IconAdapter;

public class TownDataStorage
extends JsonStorage<TownData> {
    private static TownDataStorage instance;
    private int newTownId;

    private TownDataStorage() {
        super("TAN - Towns.json", new TypeToken<LinkedHashMap<String, TownData>>(){}.getType(), new GsonBuilder().registerTypeAdapter(new TypeToken<Map<ChunkPermissionType, RelationPermission>>(){}.getType(), new EnumMapKeyValueDeserializer<ChunkPermissionType, RelationPermission>(ChunkPermissionType.class, RelationPermission.class)).registerTypeAdapter(new TypeToken<Map<TownRelation, List<String>>>(){}.getType(), new EnumMapDeserializer(TownRelation.class, new TypeToken<List<String>>(){}.getType())).registerTypeAdapter(new TypeToken<List<RelationPermission>>(){}.getType(), new EnumMapDeserializer(RelationPermission.class, new TypeToken<List<String>>(){}.getType())).registerTypeAdapter((Type)((Object)ICustomIcon.class), new IconAdapter()).setPrettyPrinting().create());
    }

    @Override
    protected void load() {
        super.load();
        int id = 0;
        for (String cle : this.dataMap.keySet()) {
            try {
                int newID = Integer.parseInt(cle.substring(1));
                if (newID <= id) continue;
                id = newID;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.newTownId = id + 1;
    }

    @Override
    public void reset() {
        instance = null;
    }

    public static TownDataStorage getInstance() {
        if (instance == null) {
            instance = new TownDataStorage();
        }
        return instance;
    }

    public TownData newTown(String townName, ITanPlayer tanPlayer) {
        String townId = this.getNextTownID();
        TownData newTown = new TownData(townId, townName, tanPlayer);
        this.put(townId, newTown);
        return newTown;
    }

    @NotNull
    private String getNextTownID() {
        String townId = "T" + this.newTownId;
        ++this.newTownId;
        return townId;
    }

    public TownData newTown(String townName) {
        String townId = this.getNextTownID();
        TownData newTown = new TownData(townId, townName);
        this.put(townId, newTown);
        return newTown;
    }

    public void deleteTown(TownData townData) {
        this.dataMap.remove(townData.getID());
        this.save();
    }

    public TownData get(ITanPlayer tanPlayer) {
        return (TownData)this.get(tanPlayer.getTownId());
    }

    public TownData get(Player player) {
        return (TownData)this.get(PlayerDataStorage.getInstance().get(player).getTownId());
    }

    public int getNumberOfTown() {
        return this.dataMap.size();
    }

    public boolean isNameUsed(String townName) {
        for (TownData town : this.dataMap.values()) {
            if (!townName.equals(town.getName())) continue;
            return true;
        }
        return false;
    }
}

