/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.tasks;

import java.util.GregorianCalendar;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.newhistory.TransactionHistoryEnum;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.events.newsletter.NewsletterStorage;
import org.leralix.tan.storage.database.DatabaseHandler;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.file.ArchiveUtil;

public class DailyTasks {
    private DailyTasks() {
        throw new IllegalStateException("Utility class");
    }

    public static void scheduleMidnightTask() {
        new BukkitRunnable(){

            public void run() {
                GregorianCalendar calendar = new GregorianCalendar();
                int minute = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("taxHourTime", 0);
                int hour = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("taxMinuteTime", 0);
                if (calendar.get(11) == hour && calendar.get(12) == minute) {
                    DailyTasks.executeMidnightTasks();
                }
            }
        }.runTaskTimer((Plugin)TownsAndNations.getPlugin(), 0L, 1200L);
    }

    public static void executeMidnightTasks() {
        DailyTasks.propertyRent();
        for (TownData town : TownDataStorage.getInstance().getAll().values()) {
            town.executeTasks();
        }
        for (RegionData regionData : RegionDataStorage.getInstance().getAll().values()) {
            regionData.executeTasks();
        }
        DailyTasks.clearOldTaxes();
        DailyTasks.updatePlayerUsernames();
        NewsletterStorage.getInstance().clearOldNewsletters();
        if (ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getBoolean("enableMidnightGenerateResource", true)) {
            LandmarkStorage.getInstance().generateAllResources();
        }
        ArchiveUtil.archiveFiles();
    }

    private static void updatePlayerUsernames() {
        for (ITanPlayer player : PlayerDataStorage.getInstance().getAll().values()) {
            player.clearName();
        }
    }

    private static void propertyRent() {
        for (TownData town : TownDataStorage.getInstance().getAll().values()) {
            for (PropertyData property : town.getProperties()) {
                if (!property.isRented()) continue;
                property.payRent();
            }
        }
    }

    public static void clearOldTaxes() {
        int timeBeforeClearingDonation = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("NumberOfDonationBeforeClearing", 90);
        int timeBeforeClearingHistory = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("TimeBeforeClearingTaxHistory", 90);
        int timeBeforeClearingSalary = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("TimeBeforeClearingSalaryHistory", 90);
        int timeBeforeClearingMisc = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("NumberOfMiscPurchaseBeforeClearing", 90);
        int timeBeforeClearingChunk = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("TimeBeforeClearingChunkHistory", 90);
        DatabaseHandler databaseHandler = TownsAndNations.getPlugin().getDatabaseHandler();
        databaseHandler.deleteOldHistory(timeBeforeClearingDonation, TransactionHistoryEnum.DONATION);
        databaseHandler.deleteOldHistory(timeBeforeClearingHistory, TransactionHistoryEnum.PLAYER_TAX);
        databaseHandler.deleteOldHistory(timeBeforeClearingHistory, TransactionHistoryEnum.SUBJECT_TAX);
        databaseHandler.deleteOldHistory(timeBeforeClearingHistory, TransactionHistoryEnum.PROPERTY_RENT_TAX);
        databaseHandler.deleteOldHistory(timeBeforeClearingHistory, TransactionHistoryEnum.PROPERTY_BUY_TAX);
        databaseHandler.deleteOldHistory(timeBeforeClearingSalary, TransactionHistoryEnum.SALARY);
        databaseHandler.deleteOldHistory(timeBeforeClearingMisc, TransactionHistoryEnum.MISCELLANEOUS);
        databaseHandler.deleteOldHistory(timeBeforeClearingChunk, TransactionHistoryEnum.CHUNK_SPENDING);
    }
}

