/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.timezone;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.timezone.TimeZoneEnum;

public class TimeZoneManager {
    private static TimeZoneManager instance;
    private TimeZoneEnum timeZoneEnum = this.getServerTimeZone();

    private TimeZoneManager() {
    }

    public static TimeZoneManager getInstance() {
        if (instance == null) {
            instance = new TimeZoneManager();
        }
        return instance;
    }

    private TimeZoneEnum getServerTimeZone() {
        ZoneOffset offset = ZonedDateTime.now().getOffset();
        return TimeZoneEnum.fromOffset(offset.getTotalSeconds() / 3600);
    }

    public String formatDateNowForPlayer(ITanPlayer tanPlayer) {
        return this.formatDateForPlayer(tanPlayer, Instant.now());
    }

    public String formatDateForPlayer(ITanPlayer tanPlayer, Instant timestamp) {
        TimeZoneEnum timeZone = tanPlayer.getTimeZone();
        return TimeZoneManager.getDate(timestamp, timeZone);
    }

    public String formatDateNowForServer() {
        return this.formatDateForServer(Instant.now());
    }

    public String formatDateForServer(Instant timestamp) {
        return TimeZoneManager.getDate(timestamp, this.getServerTimeZone());
    }

    @NotNull
    private static String getDate(Instant timestamp, TimeZoneEnum timeZone) {
        ZonedDateTime zonedDateTime = timestamp.atZone(timeZone.toZoneOffset());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMMM HH:mm").withLocale(Locale.ENGLISH);
        return formatter.format(zonedDateTime);
    }

    public TimeZoneEnum getTimezoneEnum() {
        return this.timeZoneEnum;
    }

    public void setTimeZoneEnum(TimeZoneEnum timeZoneEnum) {
        this.timeZoneEnum = timeZoneEnum;
    }

    public boolean isDayForServer() {
        ZonedDateTime zonedDateTime = Instant.now().atZone(this.getServerTimeZone().toZoneOffset());
        int hourOfDay = zonedDateTime.getHour();
        return hourOfDay >= 8 && hourOfDay < 20;
    }

    public String getRelativeTimeDescription(LangType langType, long date) {
        Instant instant = Instant.ofEpochMilli(date);
        Instant now = Instant.now();
        long diffSeconds = now.getEpochSecond() - instant.getEpochSecond();
        if (diffSeconds < 0L) {
            return Lang.RELATIVE_IN_FUTURE.get(langType, new String[0]);
        }
        long minutes = diffSeconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        long months = days / 30L;
        long years = days / 365L;
        if (diffSeconds < 60L) {
            return Lang.RELATIVE_TIME_SECOND.get(langType, String.valueOf(diffSeconds));
        }
        if (minutes < 60L) {
            return Lang.RELATIVE_TIME_MINUTE.get(langType, String.valueOf(minutes));
        }
        if (hours < 24L) {
            return Lang.RELATIVE_TIME_HOUR.get(langType, String.valueOf(hours));
        }
        if (days < 7L) {
            return Lang.RELATIVE_TIME_DAY.get(langType, String.valueOf(days));
        }
        if (months < 12L) {
            return Lang.RELATIVE_TIME_MONTH.get(langType, String.valueOf(months));
        }
        return Lang.RELATIVE_TIME_YEAR.get(langType, String.valueOf(years));
    }
}

