/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.constants;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.enums.permissions.ChunkPermissionType;

public class EnabledPermissions {
    private final Set<ChunkPermissionType> enabledPermissions = new HashSet<ChunkPermissionType>();
    private static EnabledPermissions instance;

    public static EnabledPermissions getInstance() {
        if (instance == null) {
            instance = new EnabledPermissions();
        }
        return instance;
    }

    private EnabledPermissions() {
        this.init();
    }

    public void init() {
        ConfigurationSection config = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getConfigurationSection("enabledPermissions");
        if (config == null) {
            throw new IllegalStateException("Configuration section 'enabledPermissions' is missing in the config file.");
        }
        for (ChunkPermissionType permission : ChunkPermissionType.values()) {
            if (config.getBoolean(permission.name(), true)) continue;
            this.enabledPermissions.add(permission);
        }
    }

    public boolean isPermissionDisabled(ChunkPermissionType permission) {
        return this.enabledPermissions.contains((Object)permission);
    }
}

