/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.legacy;

import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.WarRole;

public class CreateAttackData {
    private long minTime = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("MinimumTimeBeforeAttack", 120);
    private long maxTime = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("MaximumTimeBeforeAttack", 4320);
    private long selectedTime;
    private final War war;
    private final WarRole attackingSide;

    public CreateAttackData(War war, WarRole attackingSide) {
        this.minTime = this.minTime * 60L * 20L;
        this.maxTime = this.maxTime * 60L * 20L;
        this.selectedTime = (this.minTime + this.maxTime) / 2L;
        this.war = war;
        this.attackingSide = attackingSide;
    }

    public void addDeltaDateTime(long deltaDateTime) {
        this.selectedTime += deltaDateTime;
        if (this.selectedTime < this.minTime) {
            this.selectedTime = this.minTime;
        }
        if (this.selectedTime > this.maxTime) {
            this.selectedTime = this.maxTime;
        }
    }

    public long getSelectedTime() {
        return this.selectedTime;
    }

    public War getWar() {
        return this.war;
    }

    public WarRole getAttackingSide() {
        return this.attackingSide;
    }
}

