/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.legacy;

import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.ParticleUtils;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.CurrentAttacksStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.utils.gameplay.CommandExecutor;
import org.leralix.tan.war.PlannedAttack;

public class CurrentAttack {
    private final PlannedAttack attackData;
    private boolean end;
    private final long totalTime;
    private long remaining;
    private final BossBar bossBar;

    public CurrentAttack(PlannedAttack plannedAttack, long startTime, long endTime) {
        Player player;
        this.attackData = plannedAttack;
        this.end = false;
        this.remaining = this.totalTime = endTime - startTime;
        this.bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        for (TerritoryData territoryData : plannedAttack.getAttackingTerritories()) {
            for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                tanPlayer.addWar(this);
                player = tanPlayer.getPlayer();
                if (player == null) continue;
                this.bossBar.addPlayer(player);
            }
        }
        for (TerritoryData territoryData : plannedAttack.getDefendingTerritories()) {
            for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                tanPlayer.addWar(this);
                player = tanPlayer.getPlayer();
                if (player == null) continue;
                this.bossBar.addPlayer(player);
            }
        }
        CommandExecutor.applyStartWarCommands(this.getAttackData());
        this.start();
    }

    private void updateBossBar() {
        long hours = this.remaining / 72000L;
        long minutes = this.remaining % 72000L / 1200L;
        long seconds = this.remaining % 1200L / 20L;
        String timeString = String.format("%02d:%02d:%02d", hours, minutes, seconds);
        this.bossBar.setTitle(timeString);
        this.bossBar.setProgress((double)(this.totalTime - this.remaining) / (double)this.totalTime);
    }

    public void addPlayer(ITanPlayer tanPlayer) {
        Player player = tanPlayer.getPlayer();
        if (player != null && this.remaining > 0L) {
            this.bossBar.addPlayer(player);
        }
    }

    private void start() {
        BukkitRunnable timerTask = new BukkitRunnable(){

            public void run() {
                if (CurrentAttack.this.remaining > 0L && !CurrentAttack.this.end) {
                    --CurrentAttack.this.remaining;
                    CurrentAttack.this.updateBossBar();
                } else {
                    CurrentAttack.this.end();
                    this.cancel();
                }
            }
        };
        timerTask.runTaskTimer((Plugin)TownsAndNations.getPlugin(), 0L, 1L);
    }

    public void end() {
        CommandExecutor.applyEndWarCommands(this.getAttackData());
        this.end = true;
        new BukkitRunnable(){

            public void run() {
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getAttackingTerritories()) {
                    for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                        tanPlayer.removeWar(CurrentAttack.this);
                    }
                }
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getDefendingTerritories()) {
                    for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                        tanPlayer.removeWar(CurrentAttack.this);
                    }
                }
                CurrentAttack.this.bossBar.removeAll();
                CurrentAttacksStorage.remove(CurrentAttack.this);
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getAttackingTerritories()) {
                    territoryData.removeCurrentAttack(CurrentAttack.this);
                }
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getDefendingTerritories()) {
                    territoryData.removeCurrentAttack(CurrentAttack.this);
                }
            }
        }.runTaskLater((Plugin)TownsAndNations.getPlugin(), 400L);
    }

    public boolean containsPlayer(ITanPlayer tanPlayer) {
        for (TerritoryData territoryData : this.attackData.getAttackingTerritories()) {
            if (!territoryData.isPlayerIn(tanPlayer)) continue;
            return true;
        }
        for (TerritoryData territoryData : this.attackData.getDefendingTerritories()) {
            if (!territoryData.isPlayerIn(tanPlayer)) continue;
            return true;
        }
        return false;
    }

    public PlannedAttack getAttackData() {
        return this.attackData;
    }

    public void displayBoundaries() {
        for (Player player : this.attackData.getAllOnlinePlayers()) {
            if (player == null) continue;
            this.displayBoundaries(player);
        }
    }

    public void displayBoundaries(Player player) {
        Chunk centerChunk = player.getLocation().getChunk();
        World world = centerChunk.getWorld();
        String worldID = world.getUID().toString();
        int centerChunkX = centerChunk.getX();
        int centerChunkZ = centerChunk.getZ();
        int viewDistance = 4;
        for (int dx = -viewDistance; dx <= viewDistance; ++dx) {
            for (int dz = -viewDistance; dz <= viewDistance; ++dz) {
                int chunkX = centerChunkX + dx;
                int chunkZ = centerChunkZ + dz;
                if (!this.isOwnedByDefensiveSide(chunkX, chunkZ, worldID)) continue;
                int x0 = chunkX * 16;
                int z0 = chunkZ * 16;
                int y = (int)player.getLocation().getY() + 1;
                if (!this.isOwnedByDefensiveSide(chunkX, chunkZ - 1, worldID)) {
                    ParticleUtils.drawLine((Plugin)TownsAndNations.getPlugin(), (Player)player, (Vector3D)new Vector3D(x0, y, z0, worldID), (Vector3D)new Vector3D(x0 + 16, y, z0, worldID), (int)1);
                }
                if (!this.isOwnedByDefensiveSide(chunkX, chunkZ + 1, worldID)) {
                    ParticleUtils.drawLine((Plugin)TownsAndNations.getPlugin(), (Player)player, (Vector3D)new Vector3D(x0, y, z0 + 16, worldID), (Vector3D)new Vector3D(x0 + 16, y, z0 + 16, worldID), (int)1);
                }
                if (!this.isOwnedByDefensiveSide(chunkX - 1, chunkZ, worldID)) {
                    ParticleUtils.drawLine((Plugin)TownsAndNations.getPlugin(), (Player)player, (Vector3D)new Vector3D(x0, y, z0, worldID), (Vector3D)new Vector3D(x0, y, z0 + 16, worldID), (int)1);
                }
                if (this.isOwnedByDefensiveSide(chunkX + 1, chunkZ, worldID)) continue;
                ParticleUtils.drawLine((Plugin)TownsAndNations.getPlugin(), (Player)player, (Vector3D)new Vector3D(x0 + 16, y, z0, worldID), (Vector3D)new Vector3D(x0 + 16, y, z0 + 16, worldID), (int)1);
            }
        }
    }

    private boolean isOwnedByDefensiveSide(int x, int z, String worldID) {
        TerritoryChunk territoryChunk;
        ClaimedChunk2 claimedChunk2 = NewClaimedChunkStorage.getInstance().get(x, z, worldID);
        return claimedChunk2 instanceof TerritoryChunk && (territoryChunk = (TerritoryChunk)claimedChunk2).getOwnerID().equals(this.attackData.getWar().getMainDefenderID()) && !territoryChunk.isOccupied();
    }
}

