/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.internal.wrappers;

import java.util.Collection;
import java.util.Optional;
import org.leralix.lib.position.Vector2D;
import org.leralix.tan.api.internal.wrappers.LandmarkDataWrapper;
import org.leralix.tan.api.internal.wrappers.PropertyDataWrapper;
import org.leralix.tan.api.internal.wrappers.TerritoryDataWrapper;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.tan.api.interfaces.TanLandmark;
import org.tan.api.interfaces.TanProperty;
import org.tan.api.interfaces.TanTown;

public class TownDataWrapper
extends TerritoryDataWrapper
implements TanTown {
    private final TownData townData;

    private TownDataWrapper(TownData townData) {
        super(townData);
        this.townData = townData;
    }

    public static TownDataWrapper of(TownData townData) {
        if (townData == null) {
            return null;
        }
        return new TownDataWrapper(townData);
    }

    @Override
    public int getLevel() {
        return this.townData.getNewLevel().getMainLevel();
    }

    @Override
    public Collection<TanProperty> getProperties() {
        return this.townData.getPropertyDataMap().values().stream().map(PropertyDataWrapper::of).map(p -> p).toList();
    }

    @Override
    public Collection<TanLandmark> getLandmarksOwned() {
        return LandmarkStorage.getInstance().getLandmarkOf(this.townData).stream().map(LandmarkDataWrapper::of).map(l -> l).toList();
    }

    @Override
    public Optional<Vector2D> getCapitalLocation() {
        return this.townData.getCapitalLocation();
    }
}

