/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.commands.player.MapCommand;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.MapSettings;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class ClaimCommand
extends PlayerSubCommand {
    public String getName() {
        return "claim";
    }

    public String getDescription() {
        return Lang.CLAIM_CHUNK_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan claim <town/region>";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 2) {
            suggestions.add("town");
            suggestions.add("region");
        }
        return suggestions;
    }

    public void perform(Player player, String[] args) {
        TerritoryData territoryData;
        LangType langType = LangType.of(player);
        if (args.length != 2 && args.length != 4) {
            TanChatUtils.message(player, Lang.SYNTAX_ERROR.get(langType, new String[0]));
            TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
            return;
        }
        if (args[1].equals("town")) {
            territoryData = TownDataStorage.getInstance().get(player);
            if (territoryData == null) {
                TanChatUtils.message(player, Lang.PLAYER_NO_TOWN.get().getDefault());
                return;
            }
        } else if (args[1].equals("region")) {
            territoryData = RegionDataStorage.getInstance().get(player);
            if (territoryData == null) {
                TanChatUtils.message(player, Lang.TOWN_NO_REGION.get().getDefault());
                return;
            }
        } else {
            TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(this.getSyntax()).getDefault());
            return;
        }
        if (args.length == 4) {
            int x = Integer.parseInt(args[2]);
            int z = Integer.parseInt(args[3]);
            Chunk chunk = player.getWorld().getChunkAt(x, z);
            territoryData.claimChunk(player, chunk);
            MapCommand.openMap(player, new MapSettings(args[0], args[1]));
        } else {
            territoryData.claimChunk(player);
        }
    }
}

