/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.gui.user.MainMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class OpenGuiCommand
extends PlayerSubCommand {
    public String getName() {
        return "gui";
    }

    public String getDescription() {
        return Lang.TOWN_GUI_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 2;
    }

    public String getSyntax() {
        return "/tan gui";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return Collections.emptyList();
    }

    public void perform(Player player, String[] args) {
        if (args.length == 1) {
            this.getOpeningGui(player);
        } else if (args.length > 1) {
            LangType lang = PlayerDataStorage.getInstance().get(player).getLang();
            TanChatUtils.message(player, Lang.TOO_MANY_ARGS_ERROR.get(lang, new String[0]));
            TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(lang, this.getSyntax()));
        }
    }

    private void getOpeningGui(Player player) {
        new MainMenu(player);
    }
}

