/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.CurrentAttacksStorage;
import org.leralix.tan.storage.invitation.TownInviteDataStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.timezone.TimeZoneEnum;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.war.legacy.CurrentAttack;

public class PlayerData
implements ITanPlayer {
    private String UUID;
    private String storedName;
    private Double Balance;
    private String TownId;
    private Integer townRankID;
    private Integer regionRankID;
    private List<String> propertiesListID;
    private List<String> attackInvolvedIn;
    private LangType lang;
    private TimeZoneEnum timeZone;

    public PlayerData(Player player) {
        this.UUID = player.getUniqueId().toString();
        this.storedName = player.getName();
        this.Balance = Constants.getStartingBalance();
        this.TownId = null;
        this.townRankID = null;
        this.regionRankID = null;
        this.propertiesListID = new ArrayList<String>();
        this.attackInvolvedIn = new ArrayList<String>();
    }

    @Override
    public String getID() {
        return this.UUID;
    }

    @Override
    public String getNameStored() {
        if (this.storedName == null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)java.util.UUID.fromString(this.UUID));
            this.storedName = offlinePlayer.getName();
            if (this.storedName == null) {
                this.storedName = "Unknown name";
            }
        }
        return this.storedName;
    }

    @Override
    public void setNameStored(String name) {
        this.storedName = name;
    }

    @Override
    public void clearName() {
        this.storedName = null;
    }

    @Override
    public double getBalance() {
        return this.Balance;
    }

    @Override
    public void setBalance(double balance) {
        this.Balance = balance;
    }

    @Override
    public String getTownId() {
        return this.TownId;
    }

    @Override
    public TownData getTown() {
        return (TownData)TownDataStorage.getInstance().get(this.TownId);
    }

    @Override
    public boolean hasTown() {
        return this.TownId != null;
    }

    @Override
    public boolean isTownOverlord() {
        if (!this.hasTown()) {
            return false;
        }
        return this.getTown().isLeader(this.UUID);
    }

    @Override
    public RankData getTownRank() {
        if (!this.hasTown()) {
            return null;
        }
        return this.getTown().getRank(this.getTownRankID());
    }

    @Override
    public RankData getRegionRank() {
        if (!this.hasRegion()) {
            return null;
        }
        return this.getRegion().getRank(this.getRegionRankID());
    }

    @Override
    public void addToBalance(double amount) {
        this.Balance = this.Balance + amount;
    }

    @Override
    public void removeFromBalance(double amount) {
        this.Balance = this.Balance - amount;
    }

    @Override
    public boolean hasRegion() {
        if (!this.hasTown()) {
            return false;
        }
        return this.getTown().haveOverlord();
    }

    @Override
    public RegionData getRegion() {
        if (!this.hasRegion()) {
            return null;
        }
        return this.getTown().getRegion();
    }

    @Override
    public UUID getUUID() {
        return java.util.UUID.fromString(this.UUID);
    }

    @Override
    public void joinTown(TownData townData) {
        this.TownId = townData.getID();
        this.setTownRankID(townData.getDefaultRankID());
    }

    @Override
    public void leaveTown() {
        this.TownId = null;
        this.townRankID = null;
    }

    @Override
    public void setTownRankID(int townRankID) {
        this.townRankID = townRankID;
    }

    @Override
    public Integer getTownRankID() {
        return this.townRankID;
    }

    @Override
    public List<String> getPropertiesListID() {
        if (this.propertiesListID == null) {
            this.propertiesListID = new ArrayList<String>();
        }
        return this.propertiesListID;
    }

    @Override
    public void addProperty(PropertyData propertyData) {
        this.getPropertiesListID().add(propertyData.getTotalID());
    }

    @Override
    public List<PropertyData> getProperties() {
        ArrayList<PropertyData> propertyDataList = new ArrayList<PropertyData>();
        for (String propertyID : this.getPropertiesListID()) {
            String[] parts = propertyID.split("_");
            String tID = parts[0];
            String pID = parts[1];
            PropertyData nextProperty = ((TownData)TownDataStorage.getInstance().get(tID)).getProperty(pID);
            propertyDataList.add(nextProperty);
        }
        return propertyDataList;
    }

    @Override
    public void removeProperty(PropertyData propertyData) {
        this.propertiesListID.remove(propertyData.getTotalID());
    }

    @Override
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getUUID());
    }

    @Override
    public List<String> getAttackInvolvedIn() {
        if (this.attackInvolvedIn == null) {
            this.attackInvolvedIn = new ArrayList<String>();
        }
        return this.attackInvolvedIn;
    }

    @Override
    public void addWar(CurrentAttack currentAttacks) {
        if (this.getAttackInvolvedIn().contains(currentAttacks.getAttackData().getID())) {
            return;
        }
        this.getAttackInvolvedIn().add(currentAttacks.getAttackData().getID());
    }

    @Override
    public void updateCurrentAttack() {
        Iterator<String> iterator = this.getAttackInvolvedIn().iterator();
        while (iterator.hasNext()) {
            String attackID = iterator.next();
            CurrentAttack currentAttack = CurrentAttacksStorage.get(attackID);
            if (currentAttack == null || !currentAttack.containsPlayer(this)) {
                iterator.remove();
                continue;
            }
            currentAttack.addPlayer(this);
        }
    }

    @Override
    public boolean isAtWarWith(TerritoryData territoryData) {
        if (territoryData == null) {
            return false;
        }
        for (String attackID : this.getAttackInvolvedIn()) {
            CurrentAttack currentAttack = CurrentAttacksStorage.get(attackID);
            if (currentAttack == null) {
                this.getAttackInvolvedIn().remove(attackID);
                continue;
            }
            if (!currentAttack.getAttackData().getDefendingTerritories().contains(territoryData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeWar(@NotNull CurrentAttack currentAttacks) {
        this.getAttackInvolvedIn().remove(currentAttacks.getAttackData().getID());
    }

    @Override
    public TownRelation getRelationWithPlayer(Player otherPlayer) {
        return this.getRelationWithPlayer(PlayerDataStorage.getInstance().get(otherPlayer));
    }

    @Override
    public TownRelation getRelationWithPlayer(ITanPlayer otherPlayer) {
        if (!this.hasTown() || !otherPlayer.hasTown()) {
            return TownRelation.NEUTRAL;
        }
        TownData playerTown = this.getTown();
        TownData otherPlayerTown = otherPlayer.getTown();
        return playerTown.getRelationWith(otherPlayerTown);
    }

    @Override
    public Integer getRegionRankID() {
        if (!this.hasRegion()) {
            return null;
        }
        if (this.regionRankID == null) {
            this.regionRankID = this.getRegion().getDefaultRankID();
        }
        return this.regionRankID;
    }

    @Override
    public void setRegionRankID(Integer rankID) {
        this.regionRankID = rankID;
    }

    @Override
    public Integer getRankID(TerritoryData territoryData) {
        if (territoryData instanceof TownData) {
            return this.getTownRankID();
        }
        if (territoryData instanceof RegionData) {
            return this.getRegionRankID();
        }
        return null;
    }

    @Override
    public RankData getRank(TerritoryData territoryData) {
        return territoryData.getRank(this.getRankID(territoryData));
    }

    @Override
    public List<TerritoryData> getAllTerritoriesPlayerIsIn() {
        ArrayList<TerritoryData> territories = new ArrayList<TerritoryData>();
        if (this.hasTown()) {
            territories.add(this.getTown());
        }
        if (this.hasRegion()) {
            territories.add(this.getRegion());
        }
        return territories;
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getServer().getOfflinePlayer(this.getUUID());
    }

    @Override
    public LangType getLang() {
        if (this.lang == null) {
            return Lang.getServerLang();
        }
        return this.lang;
    }

    @Override
    public void setLang(LangType lang) {
        this.lang = lang;
    }

    @Override
    public void clearAllTownApplications() {
        TownInviteDataStorage.removeInvitation(this.UUID);
        for (TownData allTown : TownDataStorage.getInstance().getAll().values()) {
            allTown.removePlayerJoinRequest(this.UUID);
        }
    }

    @Override
    public void setRankID(TerritoryData territoryData, Integer defaultRankID) {
        if (territoryData instanceof TownData) {
            this.setTownRankID(defaultRankID);
        }
        if (territoryData instanceof RegionData) {
            this.setRegionRankID(defaultRankID);
        }
    }

    @Override
    public TimeZoneEnum getTimeZone() {
        if (this.timeZone == null) {
            return TimeZoneManager.getInstance().getTimezoneEnum();
        }
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZoneEnum timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public List<CurrentAttack> getCurrentAttacks() {
        ArrayList<CurrentAttack> res = new ArrayList<CurrentAttack>();
        for (TerritoryData territoryData : this.getAllTerritoriesPlayerIsIn()) {
            res.addAll(territoryData.getCurrentAttacks());
        }
        return res;
    }
}

