/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.newhistory;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.newhistory.TransactionHistory;
import org.leralix.tan.dataclass.newhistory.TransactionHistoryEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.text.StringUtil;

public class PlayerTaxHistory
extends TransactionHistory {
    public PlayerTaxHistory(String date, String territoryDataID, String playerID, double amount) {
        super(date, territoryDataID, playerID, amount);
    }

    public PlayerTaxHistory(TerritoryData territoryData, ITanPlayer tanPlayer, double amount) {
        super(territoryData.getID(), tanPlayer.getID(), amount);
    }

    @Override
    public TransactionHistoryEnum getType() {
        return TransactionHistoryEnum.PLAYER_TAX;
    }

    @Override
    public String addLoreLine() {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.getTransactionParty()));
        if (this.getAmount() >= 0.0) {
            return Lang.TAX_PAYMENT_HISTORY_LORE.get(Lang.getServerLang(), player.getName(), StringUtil.getColoredMoney(this.getAmount()));
        }
        return Lang.TAX_PAYMENT_HISTORY_LORE_NOT_ENOUGH_MONEY.get(Lang.getServerLang(), player.getName());
    }
}

