/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.newhistory;

import org.leralix.tan.dataclass.newhistory.TransactionHistory;
import org.leralix.tan.dataclass.newhistory.TransactionHistoryEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public class SubjectTaxHistory
extends TransactionHistory {
    public SubjectTaxHistory(String date, String territoryDataID, String playerID, double amount) {
        super(date, territoryDataID, playerID, amount);
    }

    public SubjectTaxHistory(TerritoryData territoryData, TerritoryData subject, double amount) {
        super(territoryData.getID(), subject.getID(), amount);
    }

    @Override
    public TransactionHistoryEnum getType() {
        return TransactionHistoryEnum.SUBJECT_TAX;
    }

    @Override
    public String addLoreLine() {
        TerritoryData vassal = TerritoryUtil.getTerritory(this.getTransactionParty());
        if (this.getAmount() > 0.0) {
            return Lang.TAX_PAYMENT_HISTORY_LORE.get(Lang.getServerLang(), vassal.getBaseColoredName(), Double.toString(this.getAmount()));
        }
        return Lang.TAX_PAYMENT_HISTORY_LORE_NOT_ENOUGH_MONEY.get(Lang.getServerLang(), vassal.getBaseColoredName());
    }
}

