/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.newhistory;

import org.leralix.tan.dataclass.newhistory.ChunkPaymentHistory;
import org.leralix.tan.dataclass.newhistory.MiscellaneousHistory;
import org.leralix.tan.dataclass.newhistory.PlayerDonationHistory;
import org.leralix.tan.dataclass.newhistory.PlayerTaxHistory;
import org.leralix.tan.dataclass.newhistory.PropertyBuyTaxTransaction;
import org.leralix.tan.dataclass.newhistory.PropertyRentTaxHistory;
import org.leralix.tan.dataclass.newhistory.SalaryPaymentHistory;
import org.leralix.tan.dataclass.newhistory.SubjectTaxHistory;
import org.leralix.tan.dataclass.newhistory.TransactionHistory;

public enum TransactionHistoryEnum {
    CHUNK_SPENDING,
    MISCELLANEOUS,
    SALARY,
    DONATION,
    PLAYER_TAX,
    SUBJECT_TAX,
    PROPERTY_RENT_TAX,
    PROPERTY_BUY_TAX;


    public TransactionHistory createTransactionHistory(String date, String territoryDataID, String transactionParty, double amount) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ChunkPaymentHistory(date, territoryDataID, amount);
            case 1 -> new MiscellaneousHistory(date, territoryDataID, amount);
            case 2 -> new SalaryPaymentHistory(date, territoryDataID, transactionParty, amount);
            case 3 -> new PlayerDonationHistory(date, territoryDataID, transactionParty, amount);
            case 4 -> new PlayerTaxHistory(date, territoryDataID, transactionParty, amount);
            case 5 -> new SubjectTaxHistory(date, territoryDataID, transactionParty, amount);
            case 6 -> new PropertyRentTaxHistory(date, territoryDataID, transactionParty, amount);
            case 7 -> new PropertyBuyTaxTransaction(date, territoryDataID, transactionParty, amount);
        };
    }
}

