/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.property;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.property.AbstractOwner;
import org.leralix.tan.dataclass.property.OwnerType;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class PlayerOwned
extends AbstractOwner {
    private final String playerID;

    public PlayerOwned(ITanPlayer player) {
        this(player.getUUID().toString());
    }

    public PlayerOwned(String playerID) {
        super(OwnerType.PLAYER);
        this.playerID = playerID;
    }

    public String getPlayerID() {
        return this.playerID;
    }

    @Override
    public String getName() {
        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.playerID)).getName();
    }

    @Override
    public boolean canAccess(ITanPlayer tanPlayer) {
        return tanPlayer.getID().equals(this.playerID);
    }

    @Override
    public void addToBalance(double amount) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(this.playerID);
        EconomyUtil.addFromBalance(tanPlayer, amount);
    }
}

