/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.enums;

import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.lang.Lang;

public enum BrowseScope {
    ALL(Lang.BROWSE_ALL_NAME, null),
    TOWNS(Lang.BROWSE_TOWNS_NAME, null),
    REGIONS(Lang.BROWSE_REGIONS_NAME, null);

    private final Lang name;
    private BrowseScope nextScope;

    private BrowseScope(Lang name, BrowseScope nextScope) {
        this.name = name;
        this.nextScope = nextScope;
    }

    public BrowseScope getNextScope() {
        return this.nextScope;
    }

    public String getName(ITanPlayer tanPlayer) {
        return this.name.get(tanPlayer);
    }

    static {
        BrowseScope.ALL.nextScope = TOWNS;
        BrowseScope.TOWNS.nextScope = REGIONS;
        BrowseScope.REGIONS.nextScope = ALL;
    }
}

