/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.TerritoryIndependentNews;

public class TerritoryVassalIndependentDAO
extends NewsletterSubDAO<TerritoryIndependentNews> {
    private static final String TABLE_NAME = "territory_vassal_independent_newsletter";

    public TerritoryVassalIndependentDAO(DataSource connection) {
        super(connection);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS territory_vassal_independent_newsletter (id VARCHAR(36) PRIMARY KEY, independentTerritoryID VARCHAR(36) NOT NULL, formerMasterID VARCHAR(36) NOT NULL)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create table territory_vassal_independent_newsletter", e);
        }
    }

    @Override
    public void save(TerritoryIndependentNews newsletter) {
        String sql = "INSERT INTO territory_vassal_independent_newsletter (id, independentTerritoryID, formerMasterID) VALUES (?, ?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getIndependentTerritoryID());
            ps.setString(3, newsletter.getFormerMasterID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save to table territory_vassal_independent_newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TerritoryIndependentNews load(UUID id, long date) {
        String sql = "SELECT independentTerritoryID, formerMasterID FROM territory_vassal_independent_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String independentTerritoryID = rs.getString("independentTerritoryID");
                String formerMasterID = rs.getString("formerMasterID");
                TerritoryIndependentNews territoryIndependentNews = new TerritoryIndependentNews(id, date, independentTerritoryID, formerMasterID);
                return territoryIndependentNews;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load from table territory_vassal_independent_newsletter", e);
        }
    }

    @Override
    public void delete(UUID id) {
        String sql = "DELETE FROM territory_vassal_independent_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table territory_vassal_independent_newsletter", e);
        }
    }
}

