/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.legacy;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.LandmarkClaimedChunk;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.admin.AdminMainMenu;
import org.leralix.tan.gui.user.MainMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.ChangeLandmarkName;
import org.leralix.tan.listeners.chat.events.ChangeTerritoryDescription;
import org.leralix.tan.listeners.chat.events.ChangeTerritoryName;
import org.leralix.tan.listeners.chat.events.CreateEmptyTown;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlannedAttackStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.file.FileUtil;
import org.leralix.tan.utils.text.TanChatUtils;
import org.leralix.tan.war.PlannedAttack;

public class AdminGUI {
    private AdminGUI() {
        throw new IllegalStateException("Utility class");
    }

    public static void openAdminWarMenu(Player player, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_WAR_MENU.get(langType, new String[0]), 6);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (PlannedAttack plannedAttack : PlannedAttackStorage.getInstance().getAll().values()) {
            ItemStack icon = plannedAttack.getAdminIcon(langType);
            GuiItem item = ItemBuilder.from(icon).asGuiItem(event -> {
                event.setCancelled(true);
                if (!plannedAttack.isAdminApproved()) {
                    if (event.isLeftClick()) {
                        plannedAttack.setAdminApproved(true);
                    } else if (event.isRightClick()) {
                        plannedAttack.end();
                    }
                }
                AdminGUI.openAdminWarMenu(player, page);
            });
            guiItems.add(item);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> AdminGUI.openLandmarks(player, 0), p -> AdminGUI.openAdminWarMenu(player, page + 1), p -> AdminGUI.openAdminWarMenu(player, page - 1));
        gui.open((HumanEntity)player);
    }

    public static void openLandmarks(final Player player, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_LANDMARK_MENU.get(langType, new String[0]), 6);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (final Landmark landmark : LandmarkStorage.getInstance().getAll().values()) {
            ItemStack icon = landmark.getIcon(langType);
            HeadUtils.addLore(icon, "", Lang.CLICK_TO_OPEN_LANDMARK_MENU.get(langType, new String[0]), Lang.GUI_GENERIC_SHIFT_CLICK_TO_TELEPORT.get(langType, new String[0]));
            GuiItem item = ItemBuilder.from(icon).asGuiItem(event -> {
                event.setCancelled(true);
                if (!event.isShiftClick()) {
                    AdminGUI.openSpecificLandmarkMenu(player, landmark);
                } else {
                    new BukkitRunnable(){

                        public void run() {
                            player.closeInventory();
                            player.teleport(landmark.getLocation());
                        }
                    }.runTaskLater((Plugin)TownsAndNations.getPlugin(), 1L);
                    SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.GOOD);
                }
            });
            guiItems.add(item);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> new AdminMainMenu(player), p -> AdminGUI.openLandmarks(player, page + 1), p -> AdminGUI.openLandmarks(player, page - 1));
        ItemStack createLandmark = HeadUtils.makeSkullB64(Lang.ADMIN_GUI_CREATE_LANDMARK.get(langType, new String[0]), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZmMzE0MzFkNjQ1ODdmZjZlZjk4YzA2NzU4MTA2ODFmOGMxM2JmOTZmNTFkOWNiMDdlZDc4NTJiMmZmZDEifX19");
        GuiItem createLandmarkGui = ItemBuilder.from(createLandmark).asGuiItem(event -> {
            event.setCancelled(true);
            ClaimedChunk2 claimedChunk = NewClaimedChunkStorage.getInstance().get(player.getLocation().getBlock().getChunk());
            if (claimedChunk instanceof LandmarkClaimedChunk) {
                TanChatUtils.message(player, Lang.ADMIN_CHUNK_ALREADY_LANDMARK.get(player));
                return;
            }
            LandmarkStorage.getInstance().addLandmark(player.getLocation());
            AdminGUI.openLandmarks(player, page);
        });
        gui.setItem(6, 4, createLandmarkGui);
        gui.open((HumanEntity)player);
    }

    private static void openSpecificLandmarkMenu(Player player, Landmark landmark) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_SPECIFIC_LANDMARK_MENU.get(langType, landmark.getName()), 3);
        ItemStack changeLandmarkName = HeadUtils.createCustomItemStack(Material.NAME_TAG, Lang.ADMIN_GUI_CHANGE_LANDMARK_NAME.get(langType, new String[0]), Lang.ADMIN_GUI_CHANGE_LANDMARK_NAME_DESC1.get(langType, new String[0]));
        ItemStack deleteLandmark = HeadUtils.createCustomItemStack(Material.BARRIER, Lang.ADMIN_GUI_DELETE_LANDMARK.get(langType, new String[0]), Lang.ADMIN_GUI_DELETE_LANDMARK_DESC1.get(langType, new String[0]));
        ItemStack ressources = landmark.getResources();
        ItemStack setReward = HeadUtils.createCustomItemStack(landmark.getResources(), Lang.SPECIFIC_LANDMARK_ICON_DESC1.get(langType, Integer.toString(ressources.getAmount()), ressources.getType().name().toLowerCase()), Lang.SPECIFIC_LANDMARK_ICON_SWITCH_REWARD.get(langType, new String[0]));
        GuiItem changeLandmarkNameGui = ItemBuilder.from(changeLandmarkName).asGuiItem(event -> {
            event.setCancelled(true);
            TanChatUtils.message(player, Lang.ENTER_NEW_VALUE.get(player));
            PlayerChatListenerStorage.register(player, new ChangeLandmarkName(landmark, Constants.getLandmarkMaxNameSize(), p -> AdminGUI.openSpecificLandmarkMenu(player, landmark)));
        });
        GuiItem deleteLandmarkGui = ItemBuilder.from(deleteLandmark).asGuiItem(event -> {
            event.setCancelled(true);
            landmark.deleteLandmark();
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_GOOD);
            AdminGUI.openLandmarks(player, 0);
        });
        GuiItem setRewardGui = ItemBuilder.from(setReward).asGuiItem(event -> {
            event.setCancelled(true);
            ItemStack itemOnCursor = player.getItemOnCursor();
            if (itemOnCursor.getType() == Material.AIR) {
                return;
            }
            TanChatUtils.message(player, Lang.ADMIN_GUI_LANDMARK_REWARD_SET.get(player, Integer.toString(itemOnCursor.getAmount()), itemOnCursor.getType().name()), SoundEnum.GOOD);
            landmark.setReward(itemOnCursor);
            AdminGUI.openSpecificLandmarkMenu(player, landmark);
        });
        gui.setItem(2, 2, changeLandmarkNameGui);
        gui.setItem(2, 4, deleteLandmarkGui);
        gui.setItem(2, 6, setRewardGui);
        gui.open((HumanEntity)player);
    }

    public static void openAdminBrowseRegion(Player player, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_REGION_MENU.get(langType, new String[0]), 6);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (RegionData regionData : RegionDataStorage.getInstance().getAll().values()) {
            ItemStack regionIcon = HeadUtils.getRegionIcon(regionData, langType);
            HeadUtils.addLore(regionIcon, Lang.ADMIN_GUI_REGION_DESC.get(langType, new String[0]));
            GuiItem regionGui = ItemBuilder.from(regionIcon).asGuiItem(event -> {
                event.setCancelled(true);
                AdminGUI.openSpecificRegionMenu(player, regionData);
            });
            guiItems.add(regionGui);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> new AdminMainMenu(player), p -> AdminGUI.openAdminBrowseRegion(player, page + 1), p -> AdminGUI.openAdminBrowseRegion(player, page - 1));
        gui.open((HumanEntity)player);
    }

    private static void openSpecificTerritoryMenu(Player player, TerritoryData territoryData) {
        if (territoryData instanceof TownData) {
            TownData townData = (TownData)territoryData;
            AdminGUI.openSpecificTownMenu(player, townData);
        } else if (territoryData instanceof RegionData) {
            RegionData regionData = (RegionData)territoryData;
            AdminGUI.openSpecificRegionMenu(player, regionData);
        }
    }

    private static void openSpecificRegionMenu(Player player, RegionData regionData) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_SPECIFIC_REGION_MENU.get(langType, new String[0]), 3);
        AdminGUI.addCommonTerritoryDebugOption(gui, player, regionData);
        ItemStack changeTownLeader = HeadUtils.createCustomItemStack(Material.PLAYER_HEAD, Lang.ADMIN_GUI_CHANGE_REGION_LEADER.get(langType, new String[0]), Lang.ADMIN_GUI_CHANGE_REGION_LEADER_DESC1.get(langType, regionData.getLeaderData().getNameStored(), regionData.getCapital().getName()));
        GuiItem changeTownLeaderGui = ItemBuilder.from(changeTownLeader).asGuiItem(event -> {
            event.setCancelled(true);
            AdminGUI.openRegionDebugChangeOwnershipPlayerSelect(player, regionData, 0);
        });
        gui.setItem(2, 6, changeTownLeaderGui);
        gui.setItem(3, 1, GuiUtil.createBackArrow(player, p -> AdminGUI.openAdminBrowseRegion(player, 0)));
        gui.open((HumanEntity)player);
    }

    private static void addCommonTerritoryDebugOption(Gui gui, Player player, TerritoryData territoryData) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        ItemStack changeRegionName = HeadUtils.createCustomItemStack(Material.NAME_TAG, Lang.ADMIN_GUI_CHANGE_TOWN_NAME.get(langType, new String[0]), Lang.ADMIN_GUI_CHANGE_TOWN_NAME_DESC1.get(langType, territoryData.getName()));
        ItemStack changeRegionDescription = HeadUtils.createCustomItemStack(Material.WRITABLE_BOOK, Lang.ADMIN_GUI_CHANGE_TOWN_DESCRIPTION.get(langType, new String[0]), Lang.ADMIN_GUI_CHANGE_TOWN_DESCRIPTION_DESC1.get(langType, territoryData.getDescription()));
        ItemStack deleteRegion = HeadUtils.createCustomItemStack(Material.BARRIER, Lang.ADMIN_GUI_DELETE_TOWN.get(langType, new String[0]), Lang.ADMIN_GUI_DELETE_TOWN_DESC1.get(langType, territoryData.getName()));
        GuiItem changeRegionNameGui = ItemBuilder.from(changeRegionName).asGuiItem(event -> {
            event.setCancelled(true);
            TanChatUtils.message(player, Lang.ENTER_NEW_VALUE.get(player));
            PlayerChatListenerStorage.register(player, new ChangeTerritoryName(territoryData, 0, p -> AdminGUI.openSpecificTerritoryMenu(player, territoryData)));
        });
        GuiItem changeRegionDescriptionGui = ItemBuilder.from(changeRegionDescription).asGuiItem(event -> {
            event.setCancelled(true);
            TanChatUtils.message(player, Lang.ENTER_NEW_VALUE.get(player));
            PlayerChatListenerStorage.register(player, new ChangeTerritoryDescription(territoryData, p -> AdminGUI.openSpecificTerritoryMenu(player, territoryData)));
        });
        GuiItem deleteRegionGui = ItemBuilder.from(deleteRegion).asGuiItem(event -> {
            event.setCancelled(true);
            FileUtil.addLineToHistory(Lang.REGION_DELETED_NEWSLETTER.get(player.getName(), territoryData.getName()));
            if (territoryData.isCapital()) {
                territoryData.getOverlord().ifPresent(overlord -> TanChatUtils.message(player, Lang.CANNOT_DELETE_TERRITORY_IF_CAPITAL.get(langType, overlord.getBaseColoredName())));
                return;
            }
            territoryData.delete();
            player.closeInventory();
        });
        gui.setItem(2, 3, changeRegionNameGui);
        gui.setItem(2, 4, changeRegionDescriptionGui);
        gui.setItem(2, 8, deleteRegionGui);
    }

    private static void openRegionDebugChangeOwnershipPlayerSelect(Player player, RegionData regionData, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_CHANGE_REGION_LEADER.get(langType, regionData.getName()), 6);
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String playerID : regionData.getPlayerIDList()) {
            ITanPlayer iterateTanPlayer = PlayerDataStorage.getInstance().get(playerID);
            ItemStack switchPlayerIcon = HeadUtils.getPlayerHead(Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerID)));
            GuiItem switchPlayerGui = ItemBuilder.from(switchPlayerIcon).asGuiItem(event -> {
                event.setCancelled(true);
                FileUtil.addLineToHistory(Lang.HISTORY_REGION_CAPITAL_CHANGED.get(player.getName(), regionData.getCapital().getName(), tanPlayer.getTown().getName()));
                regionData.setLeaderID(iterateTanPlayer.getID());
                regionData.broadcastMessageWithSound(Lang.GUI_REGION_SETTINGS_REGION_CHANGE_LEADER_BROADCAST.get(iterateTanPlayer.getNameStored()), SoundEnum.GOOD);
                if (!regionData.getCapital().getID().equals(iterateTanPlayer.getTown().getID())) {
                    regionData.broadCastMessage(Lang.GUI_REGION_SETTINGS_REGION_CHANGE_CAPITAL_BROADCAST.get(iterateTanPlayer.getTown().getName()));
                    regionData.setCapital(iterateTanPlayer.getTownId());
                }
                AdminGUI.openSpecificRegionMenu(player, regionData);
            });
            guiItems.add(switchPlayerGui);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> AdminGUI.openSpecificRegionMenu(player, regionData), p -> AdminGUI.openRegionDebugChangeOwnershipPlayerSelect(player, regionData, page + 1), p -> AdminGUI.openRegionDebugChangeOwnershipPlayerSelect(player, regionData, page - 1));
        gui.open((HumanEntity)player);
    }

    public static void openAdminBrowseTown(Player player, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_TOWN_MENU.get(langType, new String[0]), 6);
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (TownData townData : TownDataStorage.getInstance().getAll().values()) {
            ItemStack townIcon = townData.getIconWithInformations(tanPlayer.getLang());
            HeadUtils.addLore(townIcon, "", Lang.ADMIN_GUI_LEFT_CLICK_TO_MANAGE_TOWN.get(langType, new String[0]));
            GuiItem townIterationGui = ItemBuilder.from(townIcon).asGuiItem(event -> {
                event.setCancelled(true);
                AdminGUI.openSpecificTownMenu(player, townData);
            });
            guiItems.add(townIterationGui);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> new MainMenu(player), p -> AdminGUI.openAdminBrowseTown(player, page + 1), p -> AdminGUI.openAdminBrowseTown(player, page - 1));
        ItemStack createTown = HeadUtils.makeSkullB64(Lang.ADMIN_GUI_CREATE_TOWN.get(langType, new String[0]), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZmMzE0MzFkNjQ1ODdmZjZlZjk4YzA2NzU4MTA2ODFmOGMxM2JmOTZmNTFkOWNiMDdlZDc4NTJiMmZmZDEifX19", Lang.ADMIN_GUI_CREATE_TOWN_DESC1.get(langType, new String[0]));
        GuiItem createTownGui = ItemBuilder.from(createTown).asGuiItem(event -> {
            event.setCancelled(true);
            TanChatUtils.message(player, Lang.ENTER_NEW_VALUE.get(player));
            PlayerChatListenerStorage.register(player, new CreateEmptyTown(p -> AdminGUI.openAdminBrowseTown(player, 0)));
        });
        gui.setItem(6, 5, createTownGui);
        gui.open((HumanEntity)player);
    }

    public static void openSpecificTownMenu(Player player, @NotNull TownData townData) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_SPECIFIC_TOWN_MENU.get(langType, townData.getName()), 3);
        AdminGUI.addCommonTerritoryDebugOption(gui, player, townData);
        ItemStack changeTownLeader = HeadUtils.createCustomItemStack(Material.PLAYER_HEAD, Lang.ADMIN_GUI_CHANGE_TOWN_LEADER.get(langType, new String[0]), Lang.ADMIN_GUI_CHANGE_TOWN_LEADER_DESC1.get(langType, townData.getLeaderName()));
        String name = townData.getOverlord().map(TerritoryData::getName).orElseGet(() -> Lang.NO_REGION.get(langType, new String[0]));
        ItemStack setRegionIcon = HeadUtils.makeSkullB64(name, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDljMTgzMmU0ZWY1YzRhZDljNTE5ZDE5NGIxOTg1MDMwZDI1NzkxNDMzNGFhZjI3NDVjOWRmZDYxMWQ2ZDYxZCJ9fX0=");
        if (townData.haveOverlord()) {
            if (townData.isCapital()) {
                HeadUtils.addLore(setRegionIcon, Lang.GUI_CANNOT_QUIT_IF_LEADER.get(langType, new String[0]));
            } else {
                HeadUtils.addLore(setRegionIcon, Lang.GUI_RIGHT_CLICK_TO_QUIT.get(langType, new String[0]));
            }
        } else {
            HeadUtils.addLore(setRegionIcon, Lang.GUI_LEFT_CLICK_TO_SET_REGION.get(langType, new String[0]));
        }
        GuiItem changeTownLeaderGui = ItemBuilder.from(changeTownLeader).asGuiItem(event -> {
            event.setCancelled(true);
            AdminGUI.openTownDebugChangeOwnershipPlayerSelect(player, townData, 0);
        });
        GuiItem setRegionButton = ItemBuilder.from(setRegionIcon).asGuiItem(event -> {
            event.setCancelled(true);
            if (townData.haveOverlord()) {
                if (townData.isCapital()) {
                    TanChatUtils.message(player, Lang.GUI_CANNOT_QUIT_IF_LEADER.get(langType, new String[0]));
                } else {
                    townData.removeOverlord();
                    AdminGUI.openSpecificTownMenu(player, townData);
                }
            } else {
                AdminGUI.openChooseNewOverlord(player, townData, 0);
            }
        });
        gui.setItem(2, 2, setRegionButton);
        gui.setItem(2, 6, changeTownLeaderGui);
        gui.setItem(3, 1, GuiUtil.createBackArrow(player, p -> AdminGUI.openAdminBrowseTown(player, 0)));
        gui.open((HumanEntity)player);
    }

    private static void openChooseNewOverlord(Player player, TerritoryData territoryData, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_CHANGE_OVERLORD.get(langType, territoryData.getName()), 6);
        Collection territoryDataList = RegionDataStorage.getInstance().getAll().values();
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (TerritoryData potentialOverlord : territoryDataList) {
            ItemStack potentialOverlordIcon = potentialOverlord.getIconWithInformations(tanPlayer.getLang());
            HeadUtils.addLore(potentialOverlordIcon, Lang.GUI_GENERIC_CLICK_TO_SELECT.get(langType, new String[0]));
            guiItems.add(ItemBuilder.from(potentialOverlordIcon).asGuiItem(event -> {
                event.setCancelled(true);
                territoryData.setOverlord(potentialOverlord);
                AdminGUI.openSpecificTerritoryMenu(player, territoryData);
            }));
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> AdminGUI.openSpecificTerritoryMenu(player, territoryData), p -> AdminGUI.openChooseNewOverlord(player, territoryData, page + 1), p -> AdminGUI.openChooseNewOverlord(player, territoryData, page - 1));
        gui.open((HumanEntity)player);
    }

    private static void openTownDebugChangeOwnershipPlayerSelect(Player player, TownData townData, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_CHANGE_TOWN_LEADER.get(langType, townData.getName()), 3);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String playerUUID : townData.getPlayerIDList()) {
            OfflinePlayer townPlayer = Bukkit.getServer().getOfflinePlayer(UUID.fromString(playerUUID));
            ItemStack playerHead = HeadUtils.getPlayerHead(townPlayer, Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_DESC1.get(langType, townPlayer.getName()), Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_DESC2.get(langType, new String[0]));
            GuiItem playerHeadGui = ItemBuilder.from(playerHead).asGuiItem(event -> {
                event.setCancelled(true);
                FileUtil.addLineToHistory(Lang.HISTORY_TOWN_LEADER_CHANGED.get(player.getName(), townData.getLeaderData().getNameStored(), townPlayer.getName()));
                townData.setLeaderID(townPlayer.getUniqueId().toString());
                TanChatUtils.message(player, Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_SUCCESS.get(langType, townPlayer.getName()));
                AdminGUI.openSpecificTownMenu(player, townData);
            });
            guiItems.add(playerHeadGui);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> AdminGUI.openSpecificTownMenu(player, townData), p -> AdminGUI.openTownDebugChangeOwnershipPlayerSelect(player, townData, page + 1), p -> AdminGUI.openTownDebugChangeOwnershipPlayerSelect(player, townData, page - 1));
        gui.open((HumanEntity)player);
    }

    public static void openPlayerMenu(Player player, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_PLAYER_MENU.get(langType, new String[0]), 6);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (ITanPlayer tanPlayer : PlayerDataStorage.getInstance().getAll().values()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(tanPlayer.getID()));
            ItemStack playerHead = HeadUtils.getPlayerHeadInformation(offlinePlayer);
            GuiItem playerHeadGui = ItemBuilder.from(playerHead).asGuiItem(event -> {
                event.setCancelled(true);
                AdminGUI.openSpecificPlayerMenu(player, tanPlayer);
            });
            guiItems.add(playerHeadGui);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> new AdminMainMenu(player), p -> AdminGUI.openPlayerMenu(player, page + 1), p -> AdminGUI.openPlayerMenu(player, page - 1));
        gui.open((HumanEntity)player);
    }

    private static void openSpecificPlayerMenu(Player player, ITanPlayer tanPlayer) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_PLAYER_MENU.get(langType, new String[0]), 3);
        ItemStack playerHead = HeadUtils.getPlayerHeadInformation(Bukkit.getOfflinePlayer((UUID)UUID.fromString(tanPlayer.getID())));
        if (tanPlayer.hasTown()) {
            ItemStack removePlayerTown = HeadUtils.createCustomItemStack(Material.SPRUCE_DOOR, Lang.ADMIN_GUI_TOWN_PLAYER_TOWN.get(langType, tanPlayer.getTown().getName()), Lang.ADMIN_GUI_TOWN_PLAYER_TOWN_DESC1.get(langType, new String[0]), Lang.ADMIN_GUI_TOWN_PLAYER_TOWN_DESC2.get(langType, new String[0]));
            GuiItem removePlayerTownGui = ItemBuilder.from(removePlayerTown).asGuiItem(event -> {
                event.setCancelled(true);
                TownData townData = tanPlayer.getTown();
                if (townData.isLeader(tanPlayer)) {
                    TanChatUtils.message(player, Lang.GUI_TOWN_MEMBER_CANT_KICK_LEADER.get(langType, new String[0]));
                    return;
                }
                townData.removePlayer(tanPlayer);
                TanChatUtils.message(player, Lang.ADMIN_GUI_TOWN_PLAYER_LEAVE_TOWN_SUCCESS.get(langType, tanPlayer.getNameStored(), townData.getName()));
                AdminGUI.openSpecificPlayerMenu(player, tanPlayer);
            });
            gui.setItem(2, 2, removePlayerTownGui);
        } else {
            ItemStack addPlayerTown = HeadUtils.createCustomItemStack(Material.SPRUCE_DOOR, "Add player to town", "Add player to town");
            GuiItem addPlayerTownGui = ItemBuilder.from(addPlayerTown).asGuiItem(event -> {
                event.setCancelled(true);
                AdminGUI.setPlayerTown(player, tanPlayer, 0);
            });
            gui.setItem(2, 2, addPlayerTownGui);
        }
        GuiItem playerHeadGui = ItemBuilder.from(playerHead).asGuiItem(event -> event.setCancelled(true));
        gui.setItem(1, 5, playerHeadGui);
        gui.setItem(3, 1, GuiUtil.createBackArrow(player, p -> AdminGUI.openPlayerMenu(player, 0)));
        gui.open((HumanEntity)player);
    }

    private static void setPlayerTown(Player player, ITanPlayer tanPlayer, int page) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        Gui gui = GuiUtil.createChestGui(Lang.HEADER_ADMIN_SET_PLAYER_TOWN.get(langType, new String[0]), 6);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (TownData townData : TownDataStorage.getInstance().getAll().values()) {
            ItemStack townIcon = townData.getIconWithInformations(tanPlayer.getLang());
            HeadUtils.addLore(townIcon, "", Lang.ADMIN_GUI_LEFT_CLICK_TO_MANAGE_TOWN.get(langType, new String[0]));
            GuiItem townIterationGui = ItemBuilder.from(townIcon).asGuiItem(event -> {
                event.setCancelled(true);
                townData.addPlayer(tanPlayer);
                AdminGUI.openSpecificPlayerMenu(player, tanPlayer);
            });
            guiItems.add(townIterationGui);
        }
        GuiUtil.createIterator(gui, guiItems, page, player, p -> AdminGUI.openSpecificPlayerMenu(player, tanPlayer), p -> AdminGUI.setPlayerTown(player, tanPlayer, page + 1), p -> AdminGUI.setPlayerTown(player, tanPlayer, page - 1));
        gui.open((HumanEntity)player);
    }
}

