/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.service.requirements;

import java.util.List;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.service.requirements.IndividualRequirementWithCost;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.upgrade.Upgrade;
import org.leralix.tan.utils.text.NumberUtil;

public class AmountForUpgradeRequirement
extends IndividualRequirementWithCost {
    private final TerritoryData territoryData;
    private final Upgrade upgrade;
    private final List<Integer> costs;

    public AmountForUpgradeRequirement(TerritoryData territoryData, Upgrade upgrade, List<Integer> costs) {
        this.territoryData = territoryData;
        this.upgrade = upgrade;
        this.costs = costs;
    }

    @Override
    public String getLine(LangType langType) {
        double cost = this.getCost();
        if (this.isInvalid()) {
            return Lang.REQUIREMENT_COST_NEGATIVE.get(langType, Double.toString(cost));
        }
        return Lang.REQUIREMENT_COST_POSITIVE.get(langType, Double.toString(cost));
    }

    @Override
    public boolean isInvalid() {
        return this.territoryData.getBalance() < this.getCost();
    }

    public double getCost() {
        int level = this.territoryData.getNewLevel().getLevel(this.upgrade);
        if (this.costs.size() <= level) {
            return NumberUtil.roundWithDigits(this.costs.getLast().intValue());
        }
        return NumberUtil.roundWithDigits(this.costs.get(level).intValue());
    }

    @Override
    public void actionDone() {
        this.territoryData.removeFromBalance(this.getCost());
    }
}

