/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.service.requirements;

import org.bukkit.entity.Player;
import org.leralix.tan.gui.service.requirements.IndividualRequirementWithCost;
import org.leralix.tan.gui.service.requirements.model.ItemScope;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.gameplay.InventoryUtil;

public class RessourceRequirement
extends IndividualRequirementWithCost {
    private final ItemScope itemScope;
    private final Player player;
    private final int amount;

    public RessourceRequirement(ItemScope itemScope, int amount, Player player) {
        this.itemScope = itemScope;
        this.player = player;
        this.amount = amount;
    }

    @Override
    public String getLine(LangType langType) {
        if (this.isInvalid()) {
            return Lang.REQUIREMENT_RESOURCES_NEGATIVE.get(langType, this.itemScope.getName(langType), Integer.toString(this.amount), this.itemScope.getName(langType));
        }
        return Lang.REQUIREMENT_RESOURCES_POSITIVE.get(langType, this.itemScope.getName(langType), Integer.toString(this.amount), this.itemScope.getName(langType));
    }

    @Override
    public boolean isInvalid() {
        return !InventoryUtil.playerEnoughItem(this.player, this.itemScope, this.amount);
    }

    @Override
    public void actionDone() {
        InventoryUtil.removeItemsFromInventory(this.player, this.itemScope, this.amount);
    }
}

