/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.service.requirements.upgrade;

import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.service.requirements.IndividualRequirement;
import org.leralix.tan.gui.service.requirements.OtherUpgradeRequirement;
import org.leralix.tan.gui.service.requirements.UpgradeErrorRequirement;
import org.leralix.tan.gui.service.requirements.upgrade.UpgradeRequirement;
import org.leralix.tan.upgrade.Upgrade;
import org.leralix.tan.utils.constants.Constants;

public class OtherUpgradeRequirementBuilder
extends UpgradeRequirement {
    private final String otherUpgradeId;
    private final int requiredLevel;

    public OtherUpgradeRequirementBuilder(String otherUpgradeId, int requiredLevel) {
        this.otherUpgradeId = otherUpgradeId;
        this.requiredLevel = requiredLevel;
    }

    @Override
    public IndividualRequirement toIndividualRequirement(Upgrade upgrade, TerritoryData territoryData, Player player) {
        Upgrade otherUpgrade = Constants.getUpgradeStorage().getUpgradeByName(territoryData, this.otherUpgradeId);
        if (otherUpgrade == null) {
            return new UpgradeErrorRequirement();
        }
        return new OtherUpgradeRequirement(otherUpgrade, this.requiredLevel, territoryData);
    }
}

