/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.player;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.player.PlayerMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class LangMenu
extends IteratorGUI {
    public LangMenu(Player player) {
        super(player, Lang.HEADER_SELECT_LANGUAGE, 3);
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getLangItems(), this.page, this.player, p -> new PlayerMenu(this.player), p -> this.nextPage(), p -> this.previousPage());
        this.gui.setItem(3, 6, this.getPlayerGUI());
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getLangItems() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (LangType lang : LangType.values()) {
            ItemStack langIcon = lang.getIcon(this.langType);
            GuiItem langGui = ItemBuilder.from(langIcon).asGuiItem(event -> {
                this.tanPlayer.setLang(lang);
                TanChatUtils.message(this.player, Lang.GUI_LANGUAGE_CHANGED.get(this.tanPlayer, lang.getName()));
                new PlayerMenu(this.player);
            });
            guiItems.add(langGui);
        }
        return guiItems;
    }

    private GuiItem getPlayerGUI() {
        return IconManager.getInstance().get(IconKey.HELP_TRANSLATION_ICON).setName(Lang.HELP_US_TRANSLATE.get(this.tanPlayer)).setAction(event -> {
            TextComponent textComponent = new TextComponent(Lang.CLICK_HERE_TO_OPEN_BROWSER.get(this.tanPlayer));
            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://crowdin.com/project/town-and-nation"));
            this.player.spigot().sendMessage((BaseComponent)textComponent);
            this.player.closeInventory();
        }).asGuiItem(this.player, this.langType);
    }
}

