/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.player;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.events.newsletter.NewsletterScope;
import org.leralix.tan.events.newsletter.NewsletterStorage;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.player.PlayerMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class NewsletterMenu
extends IteratorGUI {
    NewsletterScope scope = NewsletterScope.SHOW_ONLY_UNREAD;

    public NewsletterMenu(Player player) {
        super(player, Lang.HEADER_NEWSLETTER, 6);
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getNewsletters(), this.page, this.player, p -> new PlayerMenu(this.player), p -> this.nextPage(), p -> this.previousPage());
        this.gui.setItem(6, 4, this.getMarkAllAsReadButton());
        this.gui.setItem(6, 5, this.getCheckScopeGui());
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getNewsletters() {
        return NewsletterStorage.getInstance().getNewsletterForPlayer(this.player, this.scope, p -> this.open());
    }

    private GuiItem getMarkAllAsReadButton() {
        return IconManager.getInstance().get(IconKey.MARK_ALL_AS_READ_ICON).setName(Lang.MARK_ALL_AS_READ.get(this.tanPlayer)).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(event -> {
            NewsletterStorage.getInstance().markAllAsReadForPlayer(this.player);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getCheckScopeGui() {
        return IconManager.getInstance().get(IconKey.CHANGE_NEWSLETTER_SCOPE_ICON).setName(Lang.NEWSLETTER_SCOPE_ICON.get(this.tanPlayer)).setDescription(Lang.NEWSLETTER_SCOPE_ICON_DESC1.get(this.scope.getName(this.tanPlayer.getLang()))).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_MODIFY).setAction(event -> {
            this.scope = this.scope.getNextScope();
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    public BasicGui setScope(NewsletterScope newsletterScope) {
        this.scope = newsletterScope;
        return this;
    }
}

