/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.service.requirements.IndividualRequirement;
import org.leralix.tan.gui.service.requirements.RankPermissionRequirement;
import org.leralix.tan.gui.user.player.PlayerMenu;
import org.leralix.tan.gui.user.property.PlayerPropertyManager;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.interact.RightClickListener;
import org.leralix.tan.listeners.interact.events.property.CreatePlayerPropertyEvent;
import org.leralix.tan.upgrade.rewards.numeric.PropertyCap;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class PlayerPropertiesMenu
extends IteratorGUI {
    public PlayerPropertiesMenu(Player player) {
        super(player, Lang.HEADER_PLAYER_PROPERTIES, 3);
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getProperties(), this.page, this.player, p -> new PlayerMenu(this.player).open(), p -> this.nextPage(), p -> this.previousPage());
        this.gui.setItem(3, 5, this.getNewPropertyButton());
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getNewPropertyButton() {
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        ArrayList<IndividualRequirement> requirements = new ArrayList<IndividualRequirement>();
        if (this.tanPlayer.hasTown()) {
            TownData townData = this.tanPlayer.getTown();
            double costPerBlock = townData.getTaxOnCreatingProperty();
            if (costPerBlock > 0.0) {
                description.add(Lang.GUI_PROPERTY_COST_PER_BLOCK.get(Double.toString(costPerBlock)));
            }
            requirements.add(townData.getNewLevel().getStat(PropertyCap.class).getRequirement(townData));
            requirements.add(new RankPermissionRequirement(townData, this.tanPlayer, RolePermission.CREATE_PROPERTY));
        } else {
            description.add(Lang.PLAYER_NO_TOWN.get());
        }
        return this.iconManager.get(IconKey.CREATE_NEW_PROPERTY_ICON).setName(Lang.GUI_PLAYER_NEW_PROPERTY.get(this.tanPlayer)).setDescription(description).setRequirements(requirements).setAction(event -> {
            if (!this.tanPlayer.hasTown()) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_TOWN.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            TanChatUtils.message(this.player, Lang.PLAYER_RIGHT_CLICK_2_POINTS_TO_CREATE_PROPERTY.get(this.tanPlayer));
            RightClickListener.register(this.player, new CreatePlayerPropertyEvent(this.player));
            this.player.closeInventory();
        }).asGuiItem(this.player, this.langType);
    }

    private List<GuiItem> getProperties() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (PropertyData propertyData : this.tanPlayer.getProperties()) {
            guiItems.add(this.iconManager.get(propertyData.getIcon()).setName(propertyData.getName()).setDescription(propertyData.getBasicDescription()).setAction(event -> new PlayerPropertyManager(this.player, propertyData, p -> this.open())).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

