/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.cosmetic.CustomIcon;
import org.leralix.tan.gui.user.property.PropertyMenus;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class PlayerPropertyManager
extends PropertyMenus {
    Consumer<Player> onClose;

    public PlayerPropertyManager(Player player, PropertyData propertyData, Consumer<Player> onClose) {
        super(player, Lang.HEADER_PLAYER_SPECIFIC_PROPERTY.get(player, propertyData.getName()), 3, propertyData);
        this.onClose = onClose;
        this.open();
    }

    @Override
    public void open() {
        this.gui.getFiller().fillTop(GuiUtil.getUnnamedItem(Material.BROWN_STAINED_GLASS_PANE));
        this.gui.setItem(1, 5, this.getPropertyIcon());
        this.gui.setItem(2, 2, this.getRenameButton());
        this.gui.setItem(2, 3, this.getDescriptionButton());
        this.gui.setItem(2, 4, this.getAuthorizedPlayersButton());
        this.gui.setItem(2, 5, this.getBoundariesButton());
        this.gui.setItem(2, 6, this.forRentButton());
        if (this.propertyData.isRented()) {
            this.gui.setItem(2, 7, this.getKickRenterButton());
        } else {
            this.gui.setItem(2, 7, this.forSaleButton());
        }
        this.gui.setItem(2, 8, this.getDeleteButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, this.onClose));
        this.gui.open((HumanEntity)this.player);
    }

    @Override
    protected GuiItem getPropertyIcon() {
        List<FilledLang> desc = this.propertyData.getBasicDescription();
        desc.add(Lang.GUI_PROPERTY_CHANGE_ICON.get());
        return this.iconManager.get(this.propertyData.getIcon()).setName(this.propertyData.getName()).setDescription(desc).setAction(event -> {
            if (event.getCursor() == null) {
                return;
            }
            if (event.getCursor().getType() == Material.AIR) {
                return;
            }
            ItemStack itemMaterial = event.getCursor();
            this.propertyData.setIcon(new CustomIcon(itemMaterial));
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.GOOD);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }
}

