/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.property.TownPropertyManager;
import org.leralix.tan.gui.user.territory.TownMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class TownPropertiesMenu
extends IteratorGUI {
    private final TownData townData;

    public TownPropertiesMenu(Player player, TownData townData) {
        super(player, Lang.HEADER_PLAYER_PROPERTIES, 3);
        this.townData = townData;
        this.open();
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getProperties(), this.page, this.player, p -> new TownMenu(this.player, this.townData), p -> this.nextPage(), p -> this.previousPage());
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getProperties() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        for (PropertyData townProperty : this.townData.getProperties()) {
            res.add(this.iconManager.get(townProperty.getIcon()).setName(townProperty.getName()).setDescription(townProperty.getBasicDescription()).setAction(event -> {
                event.setCancelled(true);
                if (!this.tanPlayer.hasTown()) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_TOWN.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                    return;
                }
                if (!this.townData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_PROPERTY)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                    return;
                }
                new TownPropertyManager(this.player, townProperty, this.townData);
            }).asGuiItem(this.player, this.langType));
        }
        return res;
    }
}

