/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.BrowseScope;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class BrowseTerritoryMenu
extends IteratorGUI {
    private final TerritoryData territoryData;
    private BrowseScope scope;
    private final Consumer<Player> exitMenu;

    public BrowseTerritoryMenu(Player player, TerritoryData territoryData, BrowseScope scope, Consumer<Player> exitMenu) {
        super(player, Lang.HEADER_TERRITORY_LIST, 6);
        this.territoryData = territoryData;
        this.scope = scope;
        this.exitMenu = exitMenu;
        this.open();
    }

    public void setScope(BrowseScope newScope) {
        this.scope = newScope;
        this.open();
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getTerritory(), this.page, this.player, this.exitMenu, p -> this.nextPage(), p -> this.previousPage());
        this.gui.setItem(6, 5, this.getScopeButton());
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getScopeButton() {
        return this.iconManager.get(IconKey.CHANGE_SCOPE_ICON).setName(Lang.BROWSE_SCOPE.get(this.tanPlayer, this.scope.getName(this.tanPlayer))).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_SWITCH).setAction(p -> this.setScope(this.scope.getNextScope())).asGuiItem(this.player, this.langType);
    }

    private List<GuiItem> getTerritory() {
        ArrayList territoryList = new ArrayList();
        if (this.scope == BrowseScope.ALL || this.scope == BrowseScope.TOWNS) {
            territoryList.addAll(TownDataStorage.getInstance().getAll().values());
        }
        if (this.scope == BrowseScope.ALL || this.scope == BrowseScope.REGIONS) {
            territoryList.addAll(RegionDataStorage.getInstance().getAll().values());
        }
        ArrayList<GuiItem> townGuiItems = new ArrayList<GuiItem>();
        for (TerritoryData specificTerritoryData : territoryList) {
            ItemStack territoryIcon = specificTerritoryData.getIconWithInformationAndRelation(this.territoryData, this.tanPlayer.getLang());
            GuiItem territoryGUI = ItemBuilder.from(territoryIcon).asGuiItem();
            townGuiItems.add(territoryGUI);
        }
        return townGuiItems;
    }
}

