/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.AddPlayerForChunkPermission;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.TanChatUtils;

public class OpenPlayerListForChunkPermission
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final ChunkPermissionType chunkPermissionType;
    private final BasicGui backMenu;

    public OpenPlayerListForChunkPermission(Player player, TerritoryData territoryData, ChunkPermissionType type, BasicGui backMenu) {
        super(player, type.getLabel(player), 6);
        this.territoryData = territoryData;
        this.chunkPermissionType = type;
        this.backMenu = backMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getAuthorizedPlayer(), p -> this.backMenu.open());
        this.gui.setItem(6, 4, this.getAddButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getAddButton() {
        ItemStack addIcon = HeadUtils.makeSkullB64(Lang.GUI_GENERIC_ADD_BUTTON.get(this.tanPlayer), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZmMzE0MzFkNjQ1ODdmZjZlZjk4YzA2NzU4MTA2ODFmOGMxM2JmOTZmNTFkOWNiMDdlZDc4NTJiMmZmZDEifX19");
        return ItemBuilder.from(addIcon).asGuiItem(event -> {
            event.setCancelled(true);
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_CLAIM_SETTINGS)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            new AddPlayerForChunkPermission(this.player, this.territoryData, this.chunkPermissionType, this);
        });
    }

    private List<GuiItem> getAuthorizedPlayer() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String authorizedPlayerID : this.territoryData.getPermission(this.chunkPermissionType).getAuthorizedPlayers()) {
            OfflinePlayer authorizedPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(authorizedPlayerID));
            ItemStack icon = HeadUtils.getPlayerHead(authorizedPlayer.getName(), authorizedPlayer, Lang.GUI_TOWN_MEMBER_DESC3.get(this.tanPlayer));
            GuiItem guiItem = ItemBuilder.from(icon).asGuiItem(event -> {
                event.setCancelled(true);
                if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_CLAIM_SETTINGS)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                    return;
                }
                if (event.isRightClick()) {
                    this.territoryData.getPermission(this.chunkPermissionType).removeSpecificPlayerPermission(authorizedPlayerID);
                    this.open();
                }
            });
            guiItems.add(guiItem);
        }
        return guiItems;
    }
}

